# frozen_string_literal: true

module Actastic
  module ActasticRecord
    AssociationDefinition = Struct.new(
      :defined_on,
      :name,
      :type,
      :class_name,
      :foreign_key,
      :inverse_of
    ) do
      def klass
        @klass ||= class_name.constantize
      end
    end
  end
end
