/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

public class ManyVarsDynamicScope
extends DynamicScope {
    private IRubyObject[] variableValues;
    public static final MethodHandle CONSTRUCTOR;

    public ManyVarsDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
        this.allocate();
    }

    private void allocate() {
        if (this.variableValues == null) {
            this.variableValues = IRubyObject.array(this.staticScope.getNumberOfVariables());
        }
    }

    public void setVariableValues(IRubyObject[] variableValues) {
        this.variableValues = variableValues;
    }

    @Override
    public IRubyObject[] getValues() {
        return this.variableValues;
    }

    @Override
    public IRubyObject getValue(int offset2, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset2, depth - 1);
        }
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, offset2)) : ManyVarsDynamicScope.failGet(this, offset2, depth);
        return variableValues[offset2];
    }

    @Override
    public IRubyObject getValueDepthZero(int offset2) {
        return this.variableValues[offset2];
    }

    @Override
    public IRubyObject getValueZeroDepthZero() {
        return this.variableValues[0];
    }

    @Override
    public IRubyObject getValueOneDepthZero() {
        return this.variableValues[1];
    }

    @Override
    public IRubyObject getValueTwoDepthZero() {
        return this.variableValues[2];
    }

    @Override
    public IRubyObject getValueThreeDepthZero() {
        return this.variableValues[3];
    }

    @Override
    public IRubyObject getValueOrNil(int offset2, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset2, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset2, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, offset2)) : ManyVarsDynamicScope.failGet(this, offset2);
        IRubyObject value2 = variableValues[offset2];
        return value2 == null ? this.setValueDepthZero(nil, offset2) : value2;
    }

    @Override
    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 0)) : ManyVarsDynamicScope.failGet(this, 0);
        IRubyObject value2 = variableValues[0];
        return value2 == null ? this.setValueZeroDepthZero(nil) : value2;
    }

    @Override
    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 1)) : ManyVarsDynamicScope.failGet(this, 1);
        IRubyObject value2 = variableValues[1];
        return value2 == null ? this.setValueOneDepthZero(nil) : value2;
    }

    @Override
    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject nil) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 2)) : ManyVarsDynamicScope.failGet(this, 2);
        IRubyObject value2 = variableValues[2];
        return value2 == null ? this.setValueTwoDepthZero(nil) : value2;
    }

    @Override
    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject nil) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 3)) : ManyVarsDynamicScope.failGet(this, 3);
        IRubyObject value2 = variableValues[3];
        return value2 == null ? this.setValueThreeDepthZero(nil) : value2;
    }

    @Override
    public void setValueVoid(IRubyObject value2, int offset2, int depth) {
        if (depth > 0) {
            DynamicScope parent = this.parent;
            assert (parent != null) : "If depth > 0, then parent should not ever be null";
            parent.setValueVoid(value2, offset2, depth - 1);
        } else {
            IRubyObject[] variableValues = this.variableValues;
            assert (ManyVarsDynamicScope.checkOffset(variableValues, offset2)) : ManyVarsDynamicScope.failSet(this, value2, offset2);
            this.setValueDepthZeroVoid(value2, offset2);
        }
    }

    @Override
    public void setValueDepthZeroVoid(IRubyObject value2, int offset2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, offset2)) : ManyVarsDynamicScope.failSet(this, value2, offset2);
        variableValues[offset2] = value2;
    }

    @Override
    public void setValueZeroDepthZeroVoid(IRubyObject value2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 0)) : ManyVarsDynamicScope.failSet(this, value2, 0);
        variableValues[0] = value2;
    }

    @Override
    public void setValueOneDepthZeroVoid(IRubyObject value2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 1)) : ManyVarsDynamicScope.failSet(this, value2, 1);
        variableValues[1] = value2;
    }

    @Override
    public void setValueTwoDepthZeroVoid(IRubyObject value2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 2)) : ManyVarsDynamicScope.failSet(this, value2, 2);
        variableValues[2] = value2;
    }

    @Override
    public void setValueThreeDepthZeroVoid(IRubyObject value2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 3)) : ManyVarsDynamicScope.failSet(this, value2, 3);
        variableValues[3] = value2;
    }

    @Override
    public void setValueFourDepthZeroVoid(IRubyObject value2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 3)) : ManyVarsDynamicScope.failSet(this, value2, 3);
        variableValues[4] = value2;
    }

    @Override
    public void setValueFiveDepthZeroVoid(IRubyObject value2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 3)) : ManyVarsDynamicScope.failSet(this, value2, 3);
        variableValues[5] = value2;
    }

    @Override
    public void setValueSixDepthZeroVoid(IRubyObject value2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 3)) : ManyVarsDynamicScope.failSet(this, value2, 3);
        variableValues[6] = value2;
    }

    @Override
    public void setValueSevenDepthZeroVoid(IRubyObject value2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 3)) : ManyVarsDynamicScope.failSet(this, value2, 3);
        variableValues[7] = value2;
    }

    @Override
    public void setValueEightDepthZeroVoid(IRubyObject value2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 3)) : ManyVarsDynamicScope.failSet(this, value2, 3);
        variableValues[8] = value2;
    }

    @Override
    public void setValueNineDepthZeroVoid(IRubyObject value2) {
        IRubyObject[] variableValues = this.variableValues;
        assert (ManyVarsDynamicScope.checkOffset(variableValues, 3)) : ManyVarsDynamicScope.failSet(this, value2, 3);
        variableValues[9] = value2;
    }

    private static boolean checkOffset(IRubyObject[] variableValues, int offset2) {
        return variableValues != null && offset2 < variableValues.length;
    }

    private static String failGet(ManyVarsDynamicScope scope, int offset2) {
        return ManyVarsDynamicScope.failGet(scope, offset2, 0);
    }

    private static String failGet(ManyVarsDynamicScope scope, int offset2, int depth) {
        return "No variables or index too big for getValue off: " + offset2 + ", Dep: " + depth + ", O: " + scope;
    }

    private static String failSet(ManyVarsDynamicScope scope, IRubyObject value2, int offset2) {
        return "Setting " + offset2 + " to " + value2 + ", O: " + scope;
    }

    @Override
    public void growIfNeeded() {
        int dynamicSize;
        int n = dynamicSize = this.variableValues == null ? 0 : this.variableValues.length;
        if (this.staticScope.getNumberOfVariables() > dynamicSize) {
            Object[] values2 = new IRubyObject[this.staticScope.getNumberOfVariables()];
            if (dynamicSize > 0) {
                ArraySupport.copy(this.variableValues, 0, values2, 0, dynamicSize);
            }
            this.variableValues = values2;
        }
    }

    @Override
    @Deprecated
    public DynamicScope cloneScope() {
        return new ManyVarsDynamicScope(this.staticScope, this.parent);
    }

    static {
        try {
            CONSTRUCTOR = MethodHandles.lookup().findConstructor(ManyVarsDynamicScope.class, MethodType.methodType(Void.TYPE, StaticScope.class, DynamicScope.class)).asType(MethodType.methodType(DynamicScope.class, StaticScope.class, DynamicScope.class));
        }
        catch (Exception e) {
            throw new RuntimeException("BUG: could not initialize constructor handle", e);
        }
    }
}

