/*
 * Decompiled with CFR 0.152.
 */
package gson_ext;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.stringio.RubyStringIO;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Gson::Encoder"})
public class Encoder
extends RubyObject {
    static final long serialVersionUID = 5035506147333315973L;
    private boolean htmlSafe = false;
    private boolean lenient = true;
    private boolean serializeNulls = true;
    private String indent = "";
    private IRubyObject options;

    public Encoder(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"lenient?"})
    public IRubyObject isLenient(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((Ruby)threadContext.getRuntime(), (boolean)this.lenient);
    }

    @JRubyMethod(name={"html_safe?"})
    public IRubyObject isHtmlSafe(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((Ruby)threadContext.getRuntime(), (boolean)this.htmlSafe);
    }

    @JRubyMethod(name={"serialize_nils?"})
    public IRubyObject isSerializeNulls(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((Ruby)threadContext.getRuntime(), (boolean)this.serializeNulls);
    }

    @JRubyMethod(name={"indent"})
    public IRubyObject getIndent(ThreadContext threadContext) {
        return RubyString.newString((Ruby)threadContext.getRuntime(), (String)this.indent);
    }

    @JRubyMethod(optional=1)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObjectArray.length < 1 || iRubyObjectArray[0].isNil()) {
            this.options = RubyHash.newHash((Ruby)ruby);
            return threadContext.nil;
        }
        if (!(iRubyObjectArray[0] instanceof RubyHash)) {
            throw ruby.newArgumentError("expected Hash for options argument");
        }
        this.options = iRubyObjectArray[0];
        RubyHash rubyHash = (RubyHash)this.options;
        RubySymbol rubySymbol = ruby.newSymbol("lenient");
        if (rubyHash.containsKey((Object)rubySymbol)) {
            this.lenient = rubyHash.op_aref(threadContext, (IRubyObject)rubySymbol).isTrue();
        }
        if (rubyHash.containsKey((Object)(rubySymbol = ruby.newSymbol("serialize_nils")))) {
            this.serializeNulls = rubyHash.op_aref(threadContext, (IRubyObject)rubySymbol).isTrue();
        }
        if (rubyHash.containsKey((Object)(rubySymbol = ruby.newSymbol("html_safe")))) {
            this.htmlSafe = rubyHash.op_aref(threadContext, (IRubyObject)rubySymbol).isTrue();
        }
        if (rubyHash.containsKey((Object)(rubySymbol = ruby.newSymbol("indent")))) {
            IRubyObject iRubyObject = rubyHash.op_aref(threadContext, (IRubyObject)rubySymbol);
            this.indent = iRubyObject.isNil() ? "" : iRubyObject.checkStringType().asJavaString();
        }
        return threadContext.nil;
    }

    @JRubyMethod(required=1, optional=1)
    public IRubyObject encode(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject;
        Ruby ruby = threadContext.getRuntime();
        Writer writer = null;
        if (iRubyObjectArray.length < 2 || iRubyObjectArray[1].isNil()) {
            writer = new StringWriter();
        } else {
            iRubyObject = iRubyObjectArray[1];
            if (iRubyObject instanceof RubyIO || iRubyObject instanceof RubyStringIO) {
                IRubyObject iRubyObject2 = IOJavaAddons.AnyIO.any_to_outputstream((ThreadContext)threadContext, (IRubyObject)iRubyObject);
                writer = new OutputStreamWriter((OutputStream)iRubyObject2.toJava(OutputStream.class));
            } else {
                throw ruby.newArgumentError("Unsupported source. This method accepts IO");
            }
        }
        iRubyObject = new JsonWriter(writer);
        iRubyObject.setLenient(this.lenient);
        iRubyObject.setHtmlSafe(this.htmlSafe);
        iRubyObject.setIndent(this.indent);
        iRubyObject.setSerializeNulls(this.serializeNulls);
        try {
            this.encodeValue((JsonWriter)iRubyObject, threadContext, iRubyObjectArray[0]);
        }
        catch (Exception exception) {
            throw EncodeError.newEncodeError(ruby, exception.getMessage());
        }
        if (writer instanceof StringWriter) {
            return ruby.newString(writer.toString());
        }
        return threadContext.nil;
    }

    private void encodeValue(JsonWriter jsonWriter, ThreadContext threadContext, IRubyObject iRubyObject) throws IOException {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject.isNil()) {
            jsonWriter.nullValue();
        } else if (iRubyObject instanceof RubyHash) {
            jsonWriter.beginObject();
            for (Object e : ((RubyHash)iRubyObject).directEntrySet()) {
                RubyHash.RubyHashEntry rubyHashEntry = (RubyHash.RubyHashEntry)e;
                jsonWriter.name(rubyHashEntry.getKey().toString());
                this.encodeValue(jsonWriter, threadContext, (IRubyObject)rubyHashEntry.getValue());
            }
            jsonWriter.endObject();
        } else if (iRubyObject instanceof RubyArray) {
            jsonWriter.beginArray();
            for (IRubyObject iRubyObject2 : ((RubyArray)iRubyObject).toJavaArray()) {
                this.encodeValue(jsonWriter, threadContext, iRubyObject2);
            }
            jsonWriter.endArray();
        } else if (iRubyObject instanceof RubyString || iRubyObject instanceof RubySymbol) {
            jsonWriter.value(iRubyObject.toString());
        } else if (iRubyObject instanceof RubyInteger) {
            try {
                jsonWriter.value(((RubyInteger)iRubyObject).getLongValue());
            }
            catch (RaiseException raiseException) {
                if ("RangeError".equals(raiseException.getException().getType().getName())) {
                    jsonWriter.value((Number)((RubyInteger)iRubyObject).getBigIntegerValue());
                }
                throw raiseException;
            }
        } else if (iRubyObject instanceof RubyFloat) {
            jsonWriter.value((Number)((RubyFloat)iRubyObject).getDoubleValue());
        } else if (iRubyObject instanceof RubyBoolean) {
            jsonWriter.value(iRubyObject.isTrue());
        } else if (iRubyObject.respondsTo("as_json")) {
            this.encodeValue(jsonWriter, threadContext, iRubyObject.callMethod(threadContext, "as_json", this.options));
        } else if (iRubyObject.respondsTo("to_s")) {
            jsonWriter.value(iRubyObject.toString());
        } else {
            jsonWriter.value(iRubyObject.anyToString().toString());
        }
        jsonWriter.flush();
    }

    @JRubyClass(name={"Gson::EncodeError"}, parent="StandardError")
    public static class EncodeError {
        public static RaiseException newEncodeError(Ruby ruby, String string) {
            RubyClass rubyClass = ruby.getModule("Gson").getClass("EncodeError");
            return new RaiseException(RubyException.newException((Ruby)ruby, (RubyClass)rubyClass, (String)string), true);
        }
    }
}

