/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ByteBuf
extends RubyObject {
    private static byte NULL_BYTE = 0;
    private static int DEFAULT_SIZE = 1024;
    private static String UTF8 = "UTF-8".intern();
    private static Encoding UTF_8 = ((EncodingDB.Entry)EncodingDB.getEncodings().get(UTF8.getBytes())).getEncoding();
    private ByteBuffer buffer;
    private Mode mode;
    private int readPosition = 0;
    private int writePosition = 0;

    public ByteBuf(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject intialize() {
        this.buffer = ByteBuffer.allocate(DEFAULT_SIZE).order(ByteOrder.LITTLE_ENDIAN);
        this.mode = Mode.WRITE;
        return null;
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(RubyString rubyString) {
        this.buffer = ByteBuffer.wrap(rubyString.getBytes()).order(ByteOrder.LITTLE_ENDIAN);
        this.mode = Mode.READ;
        return null;
    }

    @JRubyMethod(name={"get_byte"})
    public RubyString getByte() {
        this.ensureBsonRead();
        RubyString rubyString = RubyString.newString((Ruby)this.getRuntime(), (byte[])new byte[]{this.buffer.get()});
        ++this.readPosition;
        return rubyString;
    }

    @JRubyMethod(name={"get_bytes"})
    public RubyString getBytes(IRubyObject iRubyObject) {
        this.ensureBsonRead();
        int n = RubyNumeric.fix2int((RubyFixnum)((RubyFixnum)iRubyObject));
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = this.buffer.get(byArray);
        RubyString rubyString = RubyString.newString((Ruby)this.getRuntime(), (byte[])byArray);
        this.readPosition += n;
        return rubyString;
    }

    @JRubyMethod(name={"get_cstring"})
    public RubyString getCString() {
        this.ensureBsonRead();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte by = NULL_BYTE;
        while ((by = this.buffer.get()) != NULL_BYTE) {
            byteArrayOutputStream.write(by);
        }
        RubyString rubyString = this.getUTF8String(byteArrayOutputStream.toByteArray());
        this.readPosition += byteArrayOutputStream.size() + 1;
        return rubyString;
    }

    @JRubyMethod(name={"get_decimal128_bytes"})
    public RubyString getDecimal128Bytes() {
        return this.getBytes((IRubyObject)new RubyFixnum(this.getRuntime(), 16L));
    }

    @JRubyMethod(name={"get_double"})
    public RubyFloat getDouble() {
        this.ensureBsonRead();
        RubyFloat rubyFloat = new RubyFloat(this.getRuntime(), this.buffer.getDouble());
        this.readPosition += 8;
        return rubyFloat;
    }

    @JRubyMethod(name={"get_int32"})
    public RubyFixnum getInt32() {
        this.ensureBsonRead();
        RubyFixnum rubyFixnum = new RubyFixnum(this.getRuntime(), (long)this.buffer.getInt());
        this.readPosition += 4;
        return rubyFixnum;
    }

    @JRubyMethod(name={"get_string"})
    public RubyString getString() {
        this.ensureBsonRead();
        int n = this.buffer.getInt();
        this.readPosition += 4;
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, byArray.length - 1);
        RubyString rubyString = this.getUTF8String(byArray2);
        this.readPosition += n;
        return rubyString;
    }

    @JRubyMethod(name={"get_int64"})
    public RubyFixnum getInt64() {
        this.ensureBsonRead();
        RubyFixnum rubyFixnum = new RubyFixnum(this.getRuntime(), this.buffer.getLong());
        this.readPosition += 8;
        return rubyFixnum;
    }

    @JRubyMethod(name={"put_byte"})
    public ByteBuf putByte(IRubyObject iRubyObject) {
        this.ensureBsonWrite(1);
        this.buffer.put(((RubyString)iRubyObject).getBytes()[0]);
        ++this.writePosition;
        return this;
    }

    @JRubyMethod(name={"put_bytes"})
    public ByteBuf putBytes(IRubyObject iRubyObject) {
        byte[] byArray = ((RubyString)iRubyObject).getBytes();
        this.ensureBsonWrite(byArray.length);
        this.buffer.put(byArray);
        this.writePosition += byArray.length;
        return this;
    }

    @JRubyMethod(name={"put_cstring"})
    public ByteBuf putCString(IRubyObject iRubyObject) throws UnsupportedEncodingException {
        String string = ((RubyString)iRubyObject).asJavaString();
        this.writePosition += this.writeCharacters(string, true);
        return this;
    }

    @JRubyMethod(name={"put_decimal128"})
    public ByteBuf putDecimal128(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.ensureBsonWrite(16);
        BigInteger bigInteger = iRubyObject instanceof RubyBignum ? ((RubyBignum)iRubyObject).getBigIntegerValue() : ((RubyFixnum)iRubyObject).getBigIntegerValue();
        BigInteger bigInteger2 = iRubyObject2 instanceof RubyBignum ? ((RubyBignum)iRubyObject2).getBigIntegerValue() : ((RubyFixnum)iRubyObject2).getBigIntegerValue();
        this.buffer.putLong(bigInteger.longValue());
        this.writePosition += 8;
        this.buffer.putLong(bigInteger2.longValue());
        this.writePosition += 8;
        return this;
    }

    @JRubyMethod(name={"put_double"})
    public ByteBuf putDouble(IRubyObject iRubyObject) {
        this.ensureBsonWrite(8);
        this.buffer.putDouble(((RubyFloat)iRubyObject).getDoubleValue());
        this.writePosition += 8;
        return this;
    }

    @JRubyMethod(name={"put_int32"})
    public ByteBuf putInt32(IRubyObject iRubyObject) {
        this.ensureBsonWrite(4);
        this.buffer.putInt(RubyNumeric.fix2int((RubyFixnum)((RubyFixnum)iRubyObject)));
        this.writePosition += 4;
        return this;
    }

    @JRubyMethod(name={"put_int64"})
    public ByteBuf putInt64(IRubyObject iRubyObject) {
        this.ensureBsonWrite(8);
        this.buffer.putLong(((RubyInteger)iRubyObject).getLongValue());
        this.writePosition += 8;
        return this;
    }

    @JRubyMethod(name={"put_string"})
    public ByteBuf putString(IRubyObject iRubyObject) throws UnsupportedEncodingException {
        String string = ((RubyString)iRubyObject).asJavaString();
        this.ensureBsonWrite(4);
        this.buffer.putInt(0);
        int n = this.writeCharacters(string, false);
        this.buffer.putInt(this.buffer.position() - n - 4, n);
        this.writePosition += n + 4;
        return this;
    }

    @JRubyMethod(name={"replace_int32"})
    public ByteBuf replaceInt32(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = RubyNumeric.fix2int((RubyFixnum)((RubyFixnum)iRubyObject));
        int n2 = RubyNumeric.fix2int((RubyFixnum)((RubyFixnum)iRubyObject2));
        this.buffer.putInt(n, n2);
        return this;
    }

    @JRubyMethod(name={"rewind!"})
    public ByteBuf rewind() {
        this.buffer.rewind();
        this.mode = Mode.READ;
        this.readPosition = 0;
        return this;
    }

    @JRubyMethod(name={"length"})
    public RubyFixnum getLength() {
        return this.getWritePosition();
    }

    @JRubyMethod(name={"read_position"})
    public RubyFixnum getReadPosition() {
        return new RubyFixnum(this.getRuntime(), (long)this.readPosition);
    }

    @JRubyMethod(name={"write_position"})
    public RubyFixnum getWritePosition() {
        return new RubyFixnum(this.getRuntime(), (long)this.writePosition);
    }

    @JRubyMethod(name={"to_s"})
    public RubyString toRubyString() {
        this.ensureBsonRead();
        byte[] byArray = new byte[this.writePosition];
        this.buffer.get(byArray, 0, this.writePosition);
        return RubyString.newString((Ruby)this.getRuntime(), (byte[])byArray);
    }

    private RubyString getUTF8String(byte[] byArray) {
        return RubyString.newString((Ruby)this.getRuntime(), (ByteList)new ByteList(byArray, UTF_8));
    }

    private void ensureBsonRead() {
        if (this.mode == Mode.WRITE) {
            this.buffer.flip();
        }
    }

    private void ensureBsonWrite(int n) {
        if (this.mode == Mode.READ) {
            this.buffer.flip();
        }
        if (n > this.buffer.remaining()) {
            int n2 = (this.buffer.position() + n) * 2;
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            if (this.buffer.position() > 0) {
                byte[] byArray = new byte[this.buffer.position()];
                this.buffer.rewind();
                this.buffer.get(byArray);
                byteBuffer.put(byArray);
            }
            this.buffer = byteBuffer;
        }
    }

    private void write(byte by) {
        this.ensureBsonWrite(1);
        this.buffer.put(by);
    }

    private int writeCharacters(String string, boolean bl) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = Character.codePointAt(string, i);
            if (bl && n == 0) {
                throw this.getRuntime().newArgumentError(String.format("String %s is not a valid UTF-8 CString.", string));
            }
            if (n < 128) {
                this.write((byte)n);
                ++n3;
                continue;
            }
            if (n < 2048) {
                this.write((byte)(192 + (n >> 6)));
                this.write((byte)(128 + (n & 0x3F)));
                n3 += 2;
                continue;
            }
            if (n < 65536) {
                this.write((byte)(224 + (n >> 12)));
                this.write((byte)(128 + (n >> 6 & 0x3F)));
                this.write((byte)(128 + (n & 0x3F)));
                n3 += 3;
                continue;
            }
            this.write((byte)(240 + (n >> 18)));
            this.write((byte)(128 + (n >> 12 & 0x3F)));
            this.write((byte)(128 + (n >> 6 & 0x3F)));
            this.write((byte)(128 + (n & 0x3F)));
            n3 += 4;
        }
        this.write((byte)0);
        return ++n3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        READ,
        WRITE;

    }
}

