# Faux

Faux is little Rack-based DSL for generating websites. Here's a simple example:

``` ruby
class SimpleSite < Faux::Base
  page '/foo' do
    status 200
    link_to '/foobar'
  end

  page '/bar' do
    status 200
    link_to '/bang'
    link_to '/baz'
  end

  sitemap '/sitemap.xml' do
    link_to 'http://localhost:9393/foo'
    link_to '/bar'
  end

  # Adds a /robots.txt file with the specified rules.
  robots do
    user_agent '*'
    disallow '/foo'
    sitemap 'http://localhost:9393/sitemap.xml'
  end
end
```

To boot the example site locally:
``` shell
  $ bundle exec rackup
```

The site will be running at `localhost:9393`

### Request Counter

After booting an app, visit `/status` for a JSON report of which URLs have been visited and how many times they've been visited while the app has been running. It'll look like this:

``` json
{
  "/bar": 7,
  "/foo": 5
}
```

## Releasing a new version

### Configure authentication for artifactory

Create `~/.gem/credentials` with 600 permission:

```sh
mkdir -p ~/.gem && touch ~/.gem/credentials && chmod 600 ~/.gem/credentials
```

Sign into artifactory and get your API token from your [user profile](https://artifactory.elastic.dev/artifactory/webapp/#/profile).

Set `USERNAME` and `API_TOKEN` in the following snippet and run it:

```sh
export USERNAME=username
export API_TOKEN=supersecret
curl --silent --fail --user "${USERNAME}:${API_TOKEN}" \
  https://artifactory.elastic.dev/artifactory/api/gems/swiftype-gems/api/v1/api_key.json | \
  jq -r '.rubygems_api_key | ":elastic: \(.)"' > ~/.gem/credentials
```

### Release Process

When you make a change in this repository, please use the following process for
releasing your changes into Swiftype's private gem repository:

0. Follow the [above section](#Configure-authentication-for-artifactory) to configure push access to artifactory
1. Commit all of the changes you want to release.
2. Bump up the swiftype version (the number at the very end of the `VERSION` string) in `lib/faux/version.rb`.
3. Commit and push your changes to Github.
4. Run `bundle install` to make sure the gem could be installed.
5. Run `rake release` to generate a gem file and push it to artifactory
