Community Code of Conduct
=========================

The purpose of our Community Code of Conduct is to ensure that all participants in the Elastic community have the best possible experience. We are all here to help each other learn, grow our skillsets and have a good time!

The Elastic Community Code of Conduct covers our behavior as members of the Elastic community, in any forum, mailing list, wiki, web site, code repository, IRC channel, private correspondence, or public meetings.

As a worldwide community, diversity is one of our huge strengths, but it can also lead to communication issues and unhappiness. To that end, we have a few ground rules that we ask people to adhere to, to ensure that the Elastic community continues to be an excellent space in which to communicate, collaborate, and contribute.

This isn't an exhaustive list of things that you can't do. Rather, take it in the spirit in which it's intended — a guide to make it easier to be excellent to each other. We expect it to be followed in spirit as much as in the letter.

- Be considerate. Your work will be used by other people, and you in turn will depend on the work of others. Any decision you take will affect users and colleagues, and you should take those consequences into account when making decisions.
- Be patient. This mostly applies to forums, mailing lists, and code contributions (i.e. asynchronous forms of communication). Communities are often built on volunteer time both from participants and organizers. It is possible that your question or code contribution or suggestion might not receive an immediate response. Be patient and consider the norms of the community. One reminder ping is welcome, many reminder pings in rapid succession are not a good display of patience. Similarly, posting the same question in multiple threads is frowned upon and should not be done.
- Be respectful. Not all of us will agree all the time, but disagreement is no excuse for poor behavior and poor manners. We might all experience some frustration now and then, but we cannot allow that frustration to turn into a personal attack. It's important to remember that a community where people feel uncomfortable or threatened is not a productive one. We expect members of the Elastic community to be respectful when communicating with other community members, as well as with people outside the Elastic community.
- Be nice. Everyone in the Elastic community should feel welcome, regardless of their background. Please be courteous, respectful and polite to fellow community members. No offensive comments related to gender, gender identity or expression, sexual orientation, disability, physical appearance, body size, race, religion; no sexual images in public spaces, real or implied violence, intimidation, oppression, stalking, following, harassing photography or recording, sustained disruption of talks or other events, inappropriate physical contact, or unwelcome sexual attention will be tolerated.
- Communicate effectively. We don't all speak the same language at the same skill level. Clear communication can help to avoid misunderstandings, as can remembering that our interpretations of words can be different depending on our backgrounds. Having context is important. It's better to ask for clarification than to make assumptions. Disagreements, social and technical, are normal, but we expect participants in the project to resolve disagreements constructively — so please avoid flamewars, trolling, personal attacks, and repetitive arguments. Resources for how to most effectively engage with Elastic's various forums for project participation and communication — including forums, IRC, and more — are shown [here](https://www.elastic.co/community).
- Ask for help when unsure. Nobody is expected to be perfect in this community. Asking questions early avoids many problems later, so questions are encouraged, though they may be directed to the appropriate forum. Those who are asked should be responsive and helpful.

In addition to this Code of Conduct, all Elastic events are governed by the following policy. All attendees, speakers, sponsors and volunteers, including the event organizing team, are required to follow the following policy. Organizers are expected to enforce this policy throughout the event. We expect cooperation from all participants to help ensure a safe environment for everyone.

## Policy

Harassment includes offensive verbal comments related to gender, age, sexual orientation, disability, physical appearance, body size, race, religion, sexual images in public spaces, deliberate intimidation, stalking, following, harassing photography or recording, sustained disruption of talks or other events, inappropriate physical contact, and unwelcome sexual attention.

Participants asked to stop any harassing behavior are expected to comply immediately. Sponsors are also subject to the anti-harassment policy. In particular, sponsors should not use sexualized images, activities, or other material. Meetup organizing staff and other volunteer organizers should not use sexualized clothing/uniforms/costumes, or otherwise create a sexualized environment.

If a participant engages in harassing behavior, the meetup organizers may take any action they deem appropriate, including warning the offender or expulsion from the event.

If you are being harassed, notice that someone else is being harassed, or have any other concerns, please follow the directions in the "If You Need Help" section, directly below this policy.

Organizers will be happy to help participants contact security or local law enforcement, provide escorts to an alternate location, or otherwise assist those experiencing harassment to feel safe for the duration of the meetup. We value your attendance.

We expect participants to follow these rules at our all of our event venues and event-related social events.

## If You Need Help

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting [codeofconduct@elastic.co](mailto:codeofconduct@elastic.co), to any channel operator in the community IRC channels or to the local organizers of an event. As a company, we take our community's health seriously and want to ensure everyone has a good experience, so please contact us at [codeofconduct@elastic.co](mailto:codeofconduct@elastic.co) if there is an issue so we can help address it.

If you are attending Elastic{ON} 2017 in San Francisco from March 7-9, we will have extra real-time support available if you'd like to report a Code of Conduct violation — you can contact us at 1 (650) 433-2555.

The Elastic Community Code of Conduct is licensed under the [Creative Commons Attribution-Share Alike 3.0 license](http://creativecommons.org/licenses/by-sa/3.0/). Our Code of Conduct was inspired by and borrows content from Codes of Conduct of other open source projects, including:

- [Contributor Covenant](http://contributor-covenant.org/)
- [The Fedora Project](https://getfedora.org/code-of-conduct)
- [OpenStack](https://www.openstack.org/legal/community-code-of-conduct/)
- [Puppet Labs](https://docs.puppetlabs.com/community/community_guidelines.html)
- [Ubuntu](http://www.ubuntu.com/about/about-ubuntu/conduct)
