/*
 * Decompiled with CFR 0.152.
 */
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyFile;

public class WarblerJar {
    private static final Pattern PROTOCOL = Pattern.compile("^[a-z][a-z0-9]+:");

    public static void create(Ruby runtime) {
        RubyModule task = runtime.getClassFromPath("Warbler::Jar");
        task.defineAnnotatedMethods(WarblerJar.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public static IRubyObject create_jar(ThreadContext context, IRubyObject self, IRubyObject jar_path, IRubyObject entries) {
        Ruby runtime = context.runtime;
        if (!(entries instanceof RubyHash)) {
            throw runtime.newArgumentError("expected a hash for the second argument");
        }
        RubyHash hash = (RubyHash)entries;
        try {
            FileOutputStream file = WarblerJar.newFile(jar_path);
            try {
                ZipOutputStream zip = new ZipOutputStream(file);
                WarblerJar.addEntries(context, zip, hash);
                zip.finish();
            }
            finally {
                WarblerJar.close(file);
            }
        }
        catch (IOException e) {
            if (runtime.isDebug()) {
                e.printStackTrace(runtime.getOut());
            }
            throw runtime.newIOErrorFromException(e);
        }
        return runtime.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public static IRubyObject entry_in_jar(ThreadContext context, IRubyObject self, IRubyObject jar_path, IRubyObject entry) {
        IRubyObject iRubyObject;
        Ruby runtime = context.runtime;
        InputStream entryStream = WarblerJar.getStream(jar_path.convertToString().getUnicodeValue(), entry.convertToString().getUnicodeValue());
        try {
            int bytesRead;
            byte[] buf = new byte[16384];
            ByteList bytes = new ByteList();
            while ((bytesRead = entryStream.read(buf)) != -1) {
                bytes.append(buf, 0, bytesRead);
            }
            RubyModule stringio = runtime.getModule("StringIO");
            iRubyObject = stringio.callMethod(context, "new", (IRubyObject)runtime.newString(bytes));
        }
        catch (Throwable throwable) {
            try {
                WarblerJar.close(entryStream);
                throw throwable;
            }
            catch (IOException e) {
                if (runtime.isDebug()) {
                    e.printStackTrace(runtime.getOut());
                }
                throw runtime.newIOErrorFromException(e);
            }
        }
        WarblerJar.close(entryStream);
        return iRubyObject;
    }

    private static void addEntries(ThreadContext context, ZipOutputStream zip, RubyHash entries) throws IOException {
        RubyArray keys = entries.keys().sort(context, Block.NULL_BLOCK);
        for (int i = 0; i < keys.getLength(); ++i) {
            IRubyObject key = keys.entry(i);
            IRubyObject value = entries.op_aref(context, key);
            WarblerJar.addEntry(context, zip, key.convertToString().getUnicodeValue(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(ThreadContext context, ZipOutputStream zip, String entryName, IRubyObject value) throws IOException {
        File f;
        if (value.respondsTo("read")) {
            RubyString str = (RubyString)value.callMethod(context, "read").checkStringType();
            ByteList strByteList = str.getByteList();
            byte[] contents = strByteList.getUnsafeBytes();
            zip.putNextEntry(new ZipEntry(entryName));
            zip.write(contents, strByteList.getBegin(), strByteList.getRealSize());
        } else if (value.isNil() || (f = WarblerJar.getFile(value)).isDirectory()) {
            zip.putNextEntry(new ZipEntry(entryName + "/"));
        } else {
            String path = f.getPath();
            if (!f.exists()) {
                path = value.convertToString().getUnicodeValue();
            }
            try {
                InputStream inFile = WarblerJar.getStream(path, null);
                try {
                    int bytesRead;
                    zip.putNextEntry(new ZipEntry(entryName));
                    byte[] buf = new byte[16384];
                    while ((bytesRead = inFile.read(buf)) != -1) {
                        zip.write(buf, 0, bytesRead);
                    }
                }
                finally {
                    WarblerJar.close(inFile);
                }
            }
            catch (IOException e) {
                System.err.println("File not found; " + path + " not in archive");
            }
        }
    }

    private static FileOutputStream newFile(IRubyObject jar_path) throws IOException {
        return new FileOutputStream(WarblerJar.getFile(jar_path));
    }

    private static File getFile(IRubyObject path) {
        return JRubyFile.create((String)path.getRuntime().getCurrentDirectory(), (String)path.convertToString().getUnicodeValue());
    }

    private static void close(Closeable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InputStream getStream(String jar, String entry) throws IOException {
        Matcher m = PROTOCOL.matcher(jar);
        while (m.find()) {
            jar = jar.substring(m.end());
            m = PROTOCOL.matcher(jar);
        }
        String[] path = jar.split("!/");
        InputStream stream = new FileInputStream(path[0]);
        for (int i = 1; i < path.length; ++i) {
            stream = WarblerJar.entryInJar(stream, path[i]);
        }
        if (entry == null) {
            return stream;
        }
        return WarblerJar.entryInJar(stream, entry);
    }

    private static String trimTrailingSlashes(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static InputStream entryInJar(InputStream jar, String entry) throws IOException {
        ZipEntry zentry;
        entry = WarblerJar.trimTrailingSlashes(entry);
        ZipInputStream jstream = new ZipInputStream(jar);
        while ((zentry = jstream.getNextEntry()) != null) {
            if (WarblerJar.trimTrailingSlashes(zentry.getName()).equals(entry)) {
                return jstream;
            }
            jstream.closeEntry();
        }
        throw new FileNotFoundException("entry '" + entry + "' not found in " + jar);
    }
}

