/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.utils;

import fr.opensagres.poi.xwpf.converter.core.Color;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static final String replaceAll(String line, String oldString, String newString) {
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuilder buf = new StringBuilder(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static String replaceNonUnicodeChars(String text) {
        int codePoint;
        StringBuilder newString = new StringBuilder(text.length());
        block3: for (int offset = 0; offset < text.length(); offset += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(offset);
            switch (Character.getType(codePoint)) {
                case 0: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    newString.append('\u2022');
                    continue block3;
                }
            }
            newString.append(Character.toChars(codePoint));
        }
        return newString.toString();
    }

    public static String toHexString(Color colour) {
        if (colour == null) {
            return "";
        }
        String hexColour = Integer.toHexString(colour.getRGB() & 0xFFFFFF);
        if (hexColour.length() < 6) {
            hexColour = "000000".substring(0, 6 - hexColour.length()) + hexColour;
        }
        return "#" + hexColour;
    }
}

