/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class Count
extends FoldingFunction {
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            this.argument[0] = this.argument[0].unordered(true, visitor.isOptimizeForStreaming());
        }
        return e;
    }

    public int getImplementationMethod() {
        return super.getImplementationMethod() | 8;
    }

    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.ZERO, MAX_SEQUENCE_LENGTH};
    }

    public Fold getFold(XPathContext context, Sequence ... additionalArguments) throws XPathException {
        return new CountFold();
    }

    public Int64Value evaluateItem(XPathContext context) throws XPathException {
        SequenceIterator iter = this.argument[0].iterate(context);
        return new Int64Value(Count.count(iter));
    }

    public static int count(SequenceIterator iter) throws XPathException {
        if ((iter.getProperties() & 2) != 0) {
            return ((LastPositionFinder)((Object)iter)).getLength();
        }
        int n = 0;
        while (iter.next() != null) {
            ++n;
        }
        return n;
    }

    public IntegerValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        return new Int64Value(Count.count(arguments[0].iterate()));
    }

    private class CountFold
    implements Fold {
        private int count = 0;

        public void processItem(Item item) throws XPathException {
            ++this.count;
        }

        public boolean isFinished() {
            return false;
        }

        public IntegerValue result() throws XPathException {
            return Int64Value.makeIntegerValue(this.count);
        }
    }
}

