/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.servlet;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.ext.Input;

public class ServletRackEnvironment
extends HttpServletRequestWrapper
implements RackEnvironment {
    private String scriptName;
    private String requestURI;
    private String requestURIWithoutQuery;
    private String pathInfo;
    private final RackContext context;
    private final HttpServletResponse response;
    private Input io;

    public ServletRackEnvironment(HttpServletRequest request, HttpServletResponse response, RackContext context) {
        super(request);
        if (response == null) {
            throw new IllegalArgumentException("null response");
        }
        this.response = response;
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = context;
    }

    @Override
    public RackContext getContext() {
        return this.context;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletInputStream getInput() throws IOException {
        return this.getInputStream();
    }

    @Override
    public String getScriptName() {
        if (this.scriptName != null) {
            return this.scriptName;
        }
        String contextPath = this.getContextPath();
        if (contextPath == null) {
            contextPath = "";
        }
        this.scriptName = contextPath.equals("/") ? "" : contextPath;
        return this.scriptName;
    }

    @Override
    public String getPathInfo() {
        if (this.pathInfo != null) {
            return this.pathInfo;
        }
        StringBuilder buffer = new StringBuilder(32);
        String onlyURI = this.getRequestURIWithoutQuery();
        if (onlyURI.length() > 0) {
            String script = this.getScriptName();
            if (script != null && script.length() > 0 && onlyURI.indexOf(script) == 0) {
                buffer.append(onlyURI.substring(script.length()));
            } else {
                buffer.append(onlyURI);
            }
        } else {
            buffer.append(this.getServletPath());
            if (super.getPathInfo() != null) {
                buffer.append(super.getPathInfo());
            }
        }
        this.pathInfo = buffer.toString();
        return this.pathInfo;
    }

    @Override
    public String getRequestURI() {
        if (this.requestURI != null) {
            return this.requestURI;
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(this.getRequestURIWithoutQuery());
        if (super.getQueryString() != null) {
            buffer.append('?').append(super.getQueryString());
        }
        this.requestURI = buffer.toString();
        return this.requestURI;
    }

    public String getRequestURIWithoutQuery() {
        if (this.requestURIWithoutQuery != null) {
            return this.requestURIWithoutQuery;
        }
        String defaultURI = super.getRequestURI();
        this.requestURIWithoutQuery = defaultURI == null ? "" : defaultURI;
        return this.requestURIWithoutQuery;
    }

    @Deprecated
    public Input toIO() {
        return this.io;
    }

    @Deprecated
    public void setIO(Input io) {
        this.io = io;
    }
}

