/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.CompatVersion;
import org.jruby.rack.RackConfig;
import org.jruby.rack.RackException;
import org.jruby.rack.RackLogger;
import org.jruby.rack.logging.OutputStreamLogger;
import org.jruby.rack.logging.StandardOutLogger;
import org.jruby.util.SafePropertyAccessor;

public class DefaultRackConfig
implements RackConfig {
    private RackLogger logger;
    private boolean quiet = false;
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    @Override
    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(OutputStream o) {
        this.out = o == null ? System.out : (o instanceof PrintStream ? (PrintStream)o : new PrintStream(o));
    }

    @Override
    public PrintStream getErr() {
        return this.err;
    }

    public void setErr(OutputStream o) {
        this.err = o == null ? System.err : (o instanceof PrintStream ? (PrintStream)o : new PrintStream(o));
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public CompatVersion getCompatVersion() {
        Pattern pattern;
        Matcher matcher;
        String version = this.getProperty("jruby.compat.version");
        if (version != null && (matcher = (pattern = Pattern.compile("([123])[._]([8901234567])")).matcher(version)).find()) {
            String name = "RUBY" + matcher.group(1) + '_' + matcher.group(2);
            try {
                return Enum.valueOf(CompatVersion.class, name);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(RackLogger.Level.WARN, "could not resolve compat version from '" + version + "' will use default", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getRackup() {
        return this.getProperty("rackup");
    }

    @Override
    public String getRackupPath() {
        return this.getProperty("rackup.path");
    }

    @Override
    public Integer getRuntimeTimeoutSeconds() {
        Integer timeout = this.getPositiveInteger("jruby.runtime.acquire.timeout");
        if (timeout == null) {
            timeout = this.getPositiveInteger("jruby.runtime.timeout.sec");
        }
        return timeout;
    }

    @Override
    public String[] getRuntimeArguments() {
        String args = this.getProperty("jruby.runtime.arguments");
        return args == null ? null : args.trim().split("\\s+");
    }

    @Override
    public Integer getNumInitializerThreads() {
        Number threads = this.getNumberProperty("jruby.runtime.init.threads");
        if (threads == null) {
            threads = this.getNumberProperty("jruby.runtime.initializer.threads");
        }
        return threads != null ? Integer.valueOf(threads.intValue()) : null;
    }

    @Override
    public boolean isSerialInitialization() {
        Boolean serial = this.getBooleanProperty("jruby.runtime.init.serial");
        if (serial == null && (serial = this.getBooleanProperty("jruby.init.serial")) == null) {
            Integer threads = this.getNumInitializerThreads();
            serial = threads != null && threads < 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return serial;
    }

    @Override
    public RackLogger getLogger() {
        if (this.logger == null) {
            String loggerClass = this.getLoggerClassName();
            if (loggerClass != null) {
                String loggerKey;
                Map<String, String> loggerTypes = DefaultRackConfig.getLoggerTypes();
                if (loggerTypes.containsKey(loggerKey = loggerClass.toLowerCase())) {
                    loggerClass = loggerTypes.get(loggerKey);
                }
                this.logger = this.createLogger(loggerClass);
            }
            if (this.logger == null) {
                this.logger = this.defaultLogger();
            }
        }
        return this.logger;
    }

    protected RackLogger createLogger(String loggerClass) {
        if ("stdout".equalsIgnoreCase(loggerClass)) {
            return new OutputStreamLogger(this.getOut());
        }
        if ("stderr".equalsIgnoreCase(loggerClass)) {
            return new OutputStreamLogger(this.getErr());
        }
        try {
            Class<?> klass = Class.forName(loggerClass);
            try {
                Constructor<?> ctor = klass.getConstructor(String.class);
                return (RackLogger)ctor.newInstance(this.getLoggerName());
            }
            catch (NoSuchMethodException retry) {
                return DefaultRackConfig.newLoggerInstance(klass, retry);
            }
            catch (IllegalAccessException retry) {
                return DefaultRackConfig.newLoggerInstance(klass, retry);
            }
            catch (InstantiationException e) {
                throw new RackException("could not create logger: '" + loggerClass + "'", e);
            }
            catch (InvocationTargetException e) {
                throw new RackException("could not create logger: '" + loggerClass + "'", e.getTargetException());
            }
        }
        catch (Exception e) {
            if (!this.isQuiet()) {
                this.err.println("failed creating logger: '" + loggerClass + "'");
                e.printStackTrace(this.err);
            }
            return null;
        }
    }

    private static RackLogger newLoggerInstance(Class<?> klass, Exception retry) {
        try {
            return (RackLogger)klass.newInstance();
        }
        catch (Exception e) {
            throw new RackException("could not create logger: '" + klass.getName() + "' a public default () or (String) constructor is needed", e);
        }
    }

    protected RackLogger defaultLogger() {
        return new StandardOutLogger(this.getOut());
    }

    @Override
    public boolean isFilterAddsHtml() {
        return this.getBooleanProperty("jruby.rack.filter.adds.html", true);
    }

    @Override
    public boolean isFilterVerifiesResource() {
        return this.getBooleanProperty("jruby.rack.filter.verifies.resource", false);
    }

    @Override
    public String getJmsConnectionFactory() {
        return this.getProperty("jms.connection.factory");
    }

    @Override
    public String getJmsJndiProperties() {
        return this.getProperty("jms.jndi.properties");
    }

    public String getLoggerName() {
        return this.getProperty("jruby.rack.logging.name", "jruby.rack");
    }

    protected String defaultLoggerClassName() {
        return null;
    }

    public String getLoggerClassName() {
        return this.getProperty("jruby.rack.logging", this.defaultLoggerClassName());
    }

    @Override
    public Integer getInitialRuntimes() {
        return this.getRuntimesRangeValue("min", "minIdle");
    }

    @Override
    public Integer getMaximumRuntimes() {
        return this.getRuntimesRangeValue("max", "maxActive");
    }

    @Override
    public boolean isRewindable() {
        return this.getBooleanProperty("jruby.rack.input.rewindable", true);
    }

    @Override
    public Integer getInitialMemoryBufferSize() {
        return this.getPositiveInteger("jruby.rack.request.size.initial.bytes");
    }

    @Override
    public Integer getMaximumMemoryBufferSize() {
        Integer max = this.getPositiveInteger("jruby.rack.request.size.maximum.bytes");
        if (max == null) {
            max = this.getPositiveInteger("jruby.rack.request.size.threshold.bytes");
        }
        return max;
    }

    @Override
    public Map<String, String> getRuntimeEnvironment() {
        Object envFlag;
        String env = this.getProperty("jruby.runtime.env");
        if (env == null) {
            env = this.getProperty("jruby.runtime.environment");
        }
        if ((envFlag = DefaultRackConfig.toStrictBoolean(env, null)) != null) {
            boolean keep = (Boolean)envFlag;
            if (keep) {
                return new HashMap<String, String>(System.getenv());
            }
            return new HashMap<String, String>();
        }
        if (this.isIgnoreEnvironment()) {
            return new HashMap<String, String>();
        }
        return this.toStringMap(env);
    }

    static boolean isIgnoreRUBYOPT(RackConfig config) {
        Boolean rubyopt = config.getBooleanProperty("jruby.runtime.env.rubyopt");
        if (rubyopt == null) {
            return !config.isIgnoreEnvironment();
        }
        return rubyopt != null && rubyopt == false;
    }

    @Override
    public boolean isIgnoreEnvironment() {
        return this.getBooleanProperty("jruby.rack.ignore.env", false);
    }

    public boolean isThrowInitException() {
        return DefaultRackConfig.isThrowInitException(this);
    }

    static boolean isThrowInitException(RackConfig config) {
        Boolean error = config.getBooleanProperty("jruby.rack.error");
        if (error != null && !error.booleanValue()) {
            return true;
        }
        error = config.getBooleanProperty("jruby.rack.exception");
        return error != null && error == false;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return SafePropertyAccessor.getProperty((String)key, (String)defaultValue);
    }

    @Override
    public Boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, null);
    }

    @Override
    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        return DefaultRackConfig.toBoolean(this.getProperty(key), defaultValue);
    }

    @Override
    public Number getNumberProperty(String key) {
        return this.getNumberProperty(key, null);
    }

    @Override
    public Number getNumberProperty(String key, Number defaultValue) {
        return DefaultRackConfig.toNumber(this.getProperty(key), defaultValue);
    }

    private Integer getRuntimesRangeValue(String end, String gsValue) {
        Integer v = this.getPositiveInteger("jruby." + end + ".runtimes");
        if (v == null) {
            v = this.getPositiveInteger("jruby.pool." + gsValue);
        }
        return v;
    }

    private Integer getPositiveInteger(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            int i = Integer.parseInt(value);
            if (i > 0) {
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Boolean toBoolean(String value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static Object toStrictBoolean(String value, Object defaultValue) {
        if ("true".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        return defaultValue;
    }

    public static Number toNumber(String value, Number defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            float number = Float.parseFloat(value);
            if (Float.isInfinite(number)) {
                return Double.parseDouble(value);
            }
            if (Float.isNaN(number)) {
                return defaultValue;
            }
            if (number == (float)((int)number)) {
                if (number > 2.1474836E9f) {
                    return (long)number;
                }
                return (int)number;
            }
            return Float.valueOf(number);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private Map<String, String> toStringMap(String env) {
        LinkedHashMap<String, String> map;
        block6: {
            if (env == null) {
                return null;
            }
            LineNumberReader reader = new LineNumberReader(new StringReader(env.trim()));
            map = new LinkedHashMap<String, String>();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] entries = line.split(",");
                    String lastKey = null;
                    String lastVal = null;
                    for (String entry : entries) {
                        String[] pair = entry.split("=", 2);
                        if (pair.length == 1) {
                            if (entry.trim().length() == 0 || lastKey == null) continue;
                            lastVal = lastVal + ',' + entry;
                            map.put(lastKey, lastVal);
                            continue;
                        }
                        lastKey = pair[0];
                        lastVal = pair[1];
                        map.put(lastKey, lastVal);
                    }
                }
            }
            catch (IOException e) {
                if (this.isQuiet()) break block6;
                this.err.println("Failed parsing env: \n" + env);
                e.printStackTrace(this.err);
            }
        }
        return map;
    }

    private static Map<String, String> getLoggerTypes() {
        HashMap<String, String> loggerTypes = new HashMap<String, String>(8);
        loggerTypes.put("commons_logging", "org.jruby.rack.logging.CommonsLoggingLogger");
        loggerTypes.put("clogging", "org.jruby.rack.logging.CommonsLoggingLogger");
        loggerTypes.put("log4j", "org.jruby.rack.logging.Log4jLogger");
        loggerTypes.put("slf4j", "org.jruby.rack.logging.Slf4jLogger");
        loggerTypes.put("jul", "org.jruby.rack.logging.JulLogger");
        return loggerTypes;
    }
}

