/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

public class Glob {
    private Glob() {
    }

    public static boolean globMatch(String pattern, String str) {
        if (pattern == null || str == null) {
            return false;
        }
        int patternIndex = pattern.indexOf(42);
        if (patternIndex == -1) {
            return pattern.equals(str);
        }
        if (patternIndex == 0) {
            if (pattern.length() == 1) {
                return true;
            }
        } else {
            if (!str.regionMatches(0, pattern, 0, patternIndex)) {
                return false;
            }
            if (patternIndex == pattern.length() - 1) {
                return true;
            }
        }
        int strIndex = patternIndex;
        while (strIndex < str.length()) {
            assert (pattern.charAt(patternIndex) == '*') : "Expected * at index " + patternIndex + " of [" + pattern + "]";
            if (++patternIndex == pattern.length()) {
                return true;
            }
            int nextStar = pattern.indexOf(42, patternIndex);
            while (nextStar == patternIndex) {
                nextStar = pattern.indexOf(42, ++patternIndex);
            }
            if (nextStar == -1) {
                int len = pattern.length() - patternIndex;
                int strSuffixStart = str.length() - len;
                if (strSuffixStart < strIndex) {
                    return false;
                }
                return str.regionMatches(strSuffixStart, pattern, patternIndex, len);
            }
            int match = str.indexOf(pattern.substring(patternIndex, nextStar), strIndex);
            if (match == -1) {
                return false;
            }
            strIndex = match + (nextStar - patternIndex);
            patternIndex = nextStar;
        }
        while (patternIndex < pattern.length() && pattern.charAt(patternIndex) == '*') {
            ++patternIndex;
        }
        return patternIndex == pattern.length();
    }
}

