/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.rerank;

import java.util.Comparator;
import java.util.Iterator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.esql.inference.InferenceOperator;

public class RerankOperatorOutputBuilder
implements InferenceOperator.OutputBuilder {
    private final Page inputPage;
    private final DoubleBlock.Builder scoreBlockBuilder;
    private final int scoreChannel;

    public RerankOperatorOutputBuilder(DoubleBlock.Builder scoreBlockBuilder, Page inputPage, int scoreChannel) {
        this.inputPage = inputPage;
        this.scoreBlockBuilder = scoreBlockBuilder;
        this.scoreChannel = scoreChannel;
    }

    public void close() {
        Releasables.close((Releasable)this.scoreBlockBuilder);
        this.releasePageOnAnyThread(this.inputPage);
    }

    @Override
    public Page buildOutput() {
        int blockCount = Integer.max(this.inputPage.getBlockCount(), this.scoreChannel + 1);
        Block[] blocks = new Block[blockCount];
        try {
            for (int b = 0; b < blockCount; ++b) {
                if (b == this.scoreChannel) {
                    blocks[b] = this.scoreBlockBuilder.build();
                    continue;
                }
                blocks[b] = this.inputPage.getBlock(b);
                blocks[b].incRef();
            }
            return new Page(blocks);
        }
        catch (Exception e) {
            Releasables.close((Releasable[])blocks);
            throw e;
        }
    }

    @Override
    public void addInferenceResponse(InferenceAction.Response inferenceResponse) {
        Iterator sortedRankedDocIterator = this.inferenceResults(inferenceResponse).getRankedDocs().stream().sorted(Comparator.comparingInt(RankedDocsResults.RankedDoc::index)).iterator();
        while (sortedRankedDocIterator.hasNext()) {
            this.scoreBlockBuilder.appendDouble((double)((RankedDocsResults.RankedDoc)sortedRankedDocIterator.next()).relevanceScore());
        }
    }

    private RankedDocsResults inferenceResults(InferenceAction.Response inferenceResponse) {
        return InferenceOperator.OutputBuilder.inferenceResults(inferenceResponse, RankedDocsResults.class);
    }
}

