/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiff;

public final class DateDiffConstantMillisNanosEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateDiffConstantMillisNanosEvaluator.class);
    private final Source source;
    private final DateDiff.Part datePartFieldUnit;
    private final EvalOperator.ExpressionEvaluator startTimestampMillis;
    private final EvalOperator.ExpressionEvaluator endTimestampNanos;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateDiffConstantMillisNanosEvaluator(Source source, DateDiff.Part datePartFieldUnit, EvalOperator.ExpressionEvaluator startTimestampMillis, EvalOperator.ExpressionEvaluator endTimestampNanos, DriverContext driverContext) {
        this.source = source;
        this.datePartFieldUnit = datePartFieldUnit;
        this.startTimestampMillis = startTimestampMillis;
        this.endTimestampNanos = endTimestampNanos;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock startTimestampMillisBlock = (LongBlock)this.startTimestampMillis.eval(page);){
            IntBlock intBlock;
            block20: {
                LongVector endTimestampNanosVector;
                LongVector startTimestampMillisVector;
                LongBlock endTimestampNanosBlock;
                block18: {
                    IntBlock intBlock2;
                    block19: {
                        block16: {
                            IntBlock intBlock3;
                            block17: {
                                endTimestampNanosBlock = (LongBlock)this.endTimestampNanos.eval(page);
                                try {
                                    startTimestampMillisVector = startTimestampMillisBlock.asVector();
                                    if (startTimestampMillisVector != null) break block16;
                                    intBlock3 = this.eval(page.getPositionCount(), startTimestampMillisBlock, endTimestampNanosBlock);
                                    if (endTimestampNanosBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (endTimestampNanosBlock != null) {
                                        try {
                                            endTimestampNanosBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                endTimestampNanosBlock.close();
                            }
                            return intBlock3;
                        }
                        endTimestampNanosVector = endTimestampNanosBlock.asVector();
                        if (endTimestampNanosVector != null) break block18;
                        intBlock2 = this.eval(page.getPositionCount(), startTimestampMillisBlock, endTimestampNanosBlock);
                        if (endTimestampNanosBlock == null) break block19;
                        endTimestampNanosBlock.close();
                    }
                    return intBlock2;
                }
                intBlock = this.eval(page.getPositionCount(), startTimestampMillisVector, endTimestampNanosVector);
                if (endTimestampNanosBlock == null) break block20;
                endTimestampNanosBlock.close();
            }
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.startTimestampMillis.baseRamBytesUsed();
        return baseRamBytesUsed += this.endTimestampNanos.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, LongBlock startTimestampMillisBlock, LongBlock endTimestampNanosBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (startTimestampMillisBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (startTimestampMillisBlock.getValueCount(p) != 1) {
                    if (startTimestampMillisBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (endTimestampNanosBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (endTimestampNanosBlock.getValueCount(p) != 1) {
                    if (endTimestampNanosBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendInt(DateDiff.processMillisNanos(this.datePartFieldUnit, startTimestampMillisBlock.getLong(startTimestampMillisBlock.getFirstValueIndex(p)), endTimestampNanosBlock.getLong(endTimestampNanosBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, LongVector startTimestampMillisVector, LongVector endTimestampNanosVector) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendInt(DateDiff.processMillisNanos(this.datePartFieldUnit, startTimestampMillisVector.getLong(p), endTimestampNanosVector.getLong(p)));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "DateDiffConstantMillisNanosEvaluator[datePartFieldUnit=" + String.valueOf(this.datePartFieldUnit) + ", startTimestampMillis=" + String.valueOf(this.startTimestampMillis) + ", endTimestampNanos=" + String.valueOf(this.endTimestampNanos) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.startTimestampMillis, this.endTimestampNanos});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final DateDiff.Part datePartFieldUnit;
        private final EvalOperator.ExpressionEvaluator.Factory startTimestampMillis;
        private final EvalOperator.ExpressionEvaluator.Factory endTimestampNanos;

        public Factory(Source source, DateDiff.Part datePartFieldUnit, EvalOperator.ExpressionEvaluator.Factory startTimestampMillis, EvalOperator.ExpressionEvaluator.Factory endTimestampNanos) {
            this.source = source;
            this.datePartFieldUnit = datePartFieldUnit;
            this.startTimestampMillis = startTimestampMillis;
            this.endTimestampNanos = endTimestampNanos;
        }

        public DateDiffConstantMillisNanosEvaluator get(DriverContext context) {
            return new DateDiffConstantMillisNanosEvaluator(this.source, this.datePartFieldUnit, this.startTimestampMillis.get(context), this.endTimestampNanos.get(context), context);
        }

        public String toString() {
            return "DateDiffConstantMillisNanosEvaluator[datePartFieldUnit=" + String.valueOf(this.datePartFieldUnit) + ", startTimestampMillis=" + String.valueOf(this.startTimestampMillis) + ", endTimestampNanos=" + String.valueOf(this.endTimestampNanos) + "]";
        }
    }
}

