/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.plugin;

import javax.inject.Inject;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.plugin.BasePluginBuildPlugin;
import org.elasticsearch.gradle.plugin.GeneratePluginPropertiesTask;
import org.elasticsearch.gradle.plugin.GenerateTestBuildInfoTask;
import org.elasticsearch.gradle.plugin.PluginPropertiesExtension;
import org.elasticsearch.gradle.test.TestBuildInfoPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.jvm.tasks.ProcessResources;

public class PluginBuildPlugin
implements Plugin<Project> {
    protected final ProviderFactory providerFactory;

    @Inject
    public PluginBuildPlugin(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(BasePluginBuildPlugin.class);
        project.getPluginManager().apply(TestBuildInfoPlugin.class);
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("compileOnly", (Object)("org.elasticsearch:elasticsearch:" + VersionProperties.getElasticsearch()));
        dependencies.add("testImplementation", (Object)("org.elasticsearch.test:framework:" + VersionProperties.getElasticsearch()));
        PluginPropertiesExtension extension = (PluginPropertiesExtension)project.getExtensions().getByType(PluginPropertiesExtension.class);
        project.getTasks().withType(GeneratePluginPropertiesTask.class).named("pluginProperties").configure(task -> {
            task.getIsStable().set((Object)false);
            task.getClassname().set(this.providerFactory.provider(extension::getClassname));
            Provider file = project.getLayout().getBuildDirectory().file("generated-descriptor/plugin-descriptor.properties");
            task.getOutputFile().set(file);
        });
        project.getTasks().withType(GenerateTestBuildInfoTask.class).named("generateTestBuildInfo").configure(task -> {
            Jar jarTask = (Jar)project.getTasks().withType(Jar.class).named("jar").get();
            String moduleName = (String)jarTask.getManifest().getAttributes().get((Object)"Automatic-Module-Name");
            if (moduleName == null) {
                moduleName = (String)jarTask.getArchiveBaseName().getOrNull();
            }
            if (moduleName != null) {
                task.getModuleName().set((Object)moduleName);
            }
            PluginPropertiesExtension propertiesExtension = (PluginPropertiesExtension)project.getExtensions().getByType(PluginPropertiesExtension.class);
            task.getComponentName().set(this.providerFactory.provider(propertiesExtension::getName));
            task.getOutputFile().set(project.getLayout().getBuildDirectory().file("generated-build-info/plugin-test-build-info.json"));
        });
        project.getTasks().withType(ProcessResources.class).named("processResources").configure(task -> task.into(() -> "META-INF/es-plugins/" + ((PluginPropertiesExtension)project.getExtensions().getByType(PluginPropertiesExtension.class)).getName() + "/", copy -> {
            copy.from(new Object[]{project.getTasks().withType(GeneratePluginPropertiesTask.class).named("pluginProperties")});
            copy.from(new Object[]{project.getLayout().getProjectDirectory().file("src/main/plugin-metadata/entitlement-policy.yaml")});
        }));
    }
}

