/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.QueryVisitor;

public final class XIntervals {
    public static IntervalsSource ordered(IntervalsSource ... subSources) {
        return new DelegateIntervalsSource(Intervals.ordered((IntervalsSource[])subSources));
    }

    public static IntervalsSource unordered(IntervalsSource ... subSources) {
        return new DelegateIntervalsSource(Intervals.unordered((IntervalsSource[])subSources));
    }

    private static class DelegateIntervalsSource
    extends IntervalsSource {
        private final IntervalsSource delegate;

        private DelegateIntervalsSource(IntervalsSource delegate) {
            this.delegate = delegate;
        }

        public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
            return this.delegate.intervals(field, ctx);
        }

        public IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
            return this.delegate.matches(field, ctx, doc);
        }

        public void visit(String field, QueryVisitor visitor) {
            this.delegate.visit(field, visitor);
        }

        public int minExtent() {
            return this.delegate.minExtent();
        }

        public Collection<IntervalsSource> pullUpDisjunctions() {
            return this.delegate.pullUpDisjunctions();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            DelegateIntervalsSource that = (DelegateIntervalsSource)((Object)o);
            return Objects.equals(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

