/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.index.codec.tsdb.es819.ES819TSDBDocValuesConsumer;
import org.elasticsearch.index.codec.tsdb.es819.ES819TSDBDocValuesProducer;

public class ES819TSDBDocValuesFormat
extends DocValuesFormat {
    static final int NUMERIC_BLOCK_SHIFT = 7;
    public static final int NUMERIC_BLOCK_SIZE = 128;
    static final int NUMERIC_BLOCK_MASK = 127;
    static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    static final String CODEC_NAME = "ES819TSDB";
    static final String DATA_CODEC = "ES819TSDBDocValuesData";
    static final String DATA_EXTENSION = "dvd";
    static final String META_CODEC = "ES819TSDBDocValuesMetadata";
    static final String META_EXTENSION = "dvm";
    static final byte NUMERIC = 0;
    static final byte BINARY = 1;
    static final byte SORTED = 2;
    static final byte SORTED_SET = 3;
    static final byte SORTED_NUMERIC = 4;
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    static final int TERMS_DICT_BLOCK_LZ4_SHIFT = 6;
    static final int TERMS_DICT_BLOCK_LZ4_SIZE = 64;
    static final int TERMS_DICT_BLOCK_LZ4_MASK = 63;
    static final int TERMS_DICT_REVERSE_INDEX_SHIFT = 10;
    static final int TERMS_DICT_REVERSE_INDEX_SIZE = 1024;
    static final int TERMS_DICT_REVERSE_INDEX_MASK = 1023;
    static final boolean OPTIMIZED_MERGE_ENABLE_DEFAULT;
    static final String OPTIMIZED_MERGE_ENABLED_NAME;
    private final boolean enableOptimizedMerge;

    public ES819TSDBDocValuesFormat() {
        this(OPTIMIZED_MERGE_ENABLE_DEFAULT);
    }

    public ES819TSDBDocValuesFormat(boolean enableOptimizedMerge) {
        super(CODEC_NAME);
        this.enableOptimizedMerge = enableOptimizedMerge;
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new ES819TSDBDocValuesConsumer(state, this.enableOptimizedMerge, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new ES819TSDBDocValuesProducer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }

    static {
        OPTIMIZED_MERGE_ENABLED_NAME = ES819TSDBDocValuesConsumer.class.getName() + ".enableOptimizedMerge";
        OPTIMIZED_MERGE_ENABLE_DEFAULT = Boolean.parseBoolean(System.getProperty(OPTIMIZED_MERGE_ENABLED_NAME, Boolean.TRUE.toString()));
    }
}

