/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ingest.SimulateExecutionService;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class SimulatePipelineTransportAction
extends HandledTransportAction<SimulatePipelineRequest, SimulatePipelineResponse> {
    private static final Logger logger = LogManager.getLogger(SimulatePipelineTransportAction.class);
    public static final Setting<TimeValue> INGEST_NODE_TRANSPORT_ACTION_TIMEOUT = Setting.timeSetting("ingest_node.transport_action_timeout", TimeValue.timeValueSeconds((long)20L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final IngestService ingestService;
    private final SimulateExecutionService executionService;
    private final TransportService transportService;
    private volatile TimeValue ingestNodeTransportActionTimeout;
    private final ThreadLocal<Random> random = ThreadLocal.withInitial(Randomness::get);

    @Inject
    public SimulatePipelineTransportAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IngestService ingestService) {
        super("cluster:admin/ingest/pipeline/simulate", transportService, actionFilters, SimulatePipelineRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.ingestService = ingestService;
        this.executionService = new SimulateExecutionService(threadPool);
        this.transportService = transportService;
        this.ingestNodeTransportActionTimeout = INGEST_NODE_TRANSPORT_ACTION_TIMEOUT.get(ingestService.getClusterService().getSettings());
        ingestService.getClusterService().getClusterSettings().addSettingsUpdateConsumer(INGEST_NODE_TRANSPORT_ACTION_TIMEOUT, newTimeout -> {
            this.ingestNodeTransportActionTimeout = newTimeout;
        });
    }

    @Override
    protected void doExecute(Task task, SimulatePipelineRequest request, ActionListener<SimulatePipelineResponse> listener) {
        Map source = (Map)XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
        DiscoveryNodes discoveryNodes = this.ingestService.getClusterService().state().nodes();
        Map<String, DiscoveryNode> ingestNodes = discoveryNodes.getIngestNodes();
        if (ingestNodes.isEmpty()) {
            listener.onFailure(new IllegalStateException("There are no ingest nodes in this cluster, unable to forward request to an ingest node."));
            return;
        }
        try {
            if (discoveryNodes.getLocalNode().isIngestNode()) {
                SimulatePipelineRequest.Parsed simulateRequest = request.getId() != null ? SimulatePipelineRequest.parseWithPipelineId(request.getId(), source, request.isVerbose(), this.ingestService, request.getRestApiVersion()) : SimulatePipelineRequest.parse(source, request.isVerbose(), this.ingestService, request.getRestApiVersion());
                this.executionService.execute(simulateRequest, listener);
            } else {
                DiscoveryNode ingestNode = this.getRandomIngestNode(ingestNodes.values());
                logger.trace("forwarding request [{}] to ingest node [{}]", (Object)this.actionName, (Object)ingestNode);
                ActionListenerResponseHandler<SimulatePipelineResponse> handler = new ActionListenerResponseHandler<SimulatePipelineResponse>(listener, SimulatePipelineResponse::new, TransportResponseHandler.TRANSPORT_WORKER);
                if (task == null) {
                    this.transportService.sendRequest(ingestNode, this.actionName, request, handler);
                } else {
                    this.transportService.sendChildRequest(ingestNode, this.actionName, (TransportRequest)request, task, TransportRequestOptions.timeout(this.ingestNodeTransportActionTimeout), handler);
                }
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private DiscoveryNode getRandomIngestNode(Collection<DiscoveryNode> ingestNodes) {
        return ingestNodes.toArray(new DiscoveryNode[0])[this.random.get().nextInt(ingestNodes.size())];
    }
}

