/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.ServiceDisruptionScheme;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.TransportService;

public class NetworkDisruption
implements ServiceDisruptionScheme {
    private static final Logger logger = LogManager.getLogger(NetworkDisruption.class);
    private final DisruptedLinks disruptedLinks;
    private final NetworkLinkDisruptionType networkLinkDisruptionType;
    protected volatile InternalTestCluster cluster;
    protected volatile boolean activeDisruption = false;
    public static final NetworkLinkDisruptionType DISCONNECT = new NetworkLinkDisruptionType(){

        @Override
        public void applyDisruption(MockTransportService sourceTransportService, MockTransportService targetTransportService) {
            sourceTransportService.addFailToSendNoConnectRule(targetTransportService);
        }

        public String toString() {
            return "network disconnects";
        }
    };
    public static final NetworkLinkDisruptionType UNRESPONSIVE = new NetworkLinkDisruptionType(){

        @Override
        public void applyDisruption(MockTransportService sourceTransportService, MockTransportService targetTransportService) {
            sourceTransportService.addUnresponsiveRule(targetTransportService);
        }

        public String toString() {
            return "network unresponsive";
        }
    };

    public NetworkDisruption(DisruptedLinks disruptedLinks, NetworkLinkDisruptionType networkLinkDisruptionType) {
        this.disruptedLinks = disruptedLinks;
        this.networkLinkDisruptionType = networkLinkDisruptionType;
    }

    public DisruptedLinks getDisruptedLinks() {
        return this.disruptedLinks;
    }

    public NetworkLinkDisruptionType getNetworkLinkDisruptionType() {
        return this.networkLinkDisruptionType;
    }

    @Override
    public void applyToCluster(InternalTestCluster testCluster) {
        this.cluster = testCluster;
    }

    @Override
    public void removeFromCluster(InternalTestCluster testCluster) {
        this.stopDisrupting();
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster testCluster) {
        this.removeFromCluster(testCluster);
        this.ensureHealthy(testCluster);
    }

    public void ensureHealthy(InternalTestCluster testCluster) {
        assert (!this.activeDisruption);
        this.ensureNodeCount(testCluster);
        NetworkDisruption.ensureFullyConnectedCluster(testCluster);
    }

    public static void ensureFullyConnectedCluster(InternalTestCluster cluster) {
        String[] nodeNames = cluster.getNodeNames();
        CountDownLatch countDownLatch = new CountDownLatch(nodeNames.length);
        for (String node : nodeNames) {
            ClusterState stateOnNode = cluster.getInstance(ClusterService.class, node).state();
            cluster.getInstance(NodeConnectionsService.class, node).reconnectToNodes(stateOnNode.nodes(), countDownLatch::countDown);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void ensureNodeCount(InternalTestCluster testCluster) {
        testCluster.validateClusterFormed();
    }

    @Override
    public synchronized void applyToNode(String node, InternalTestCluster testCluster) {
    }

    @Override
    public synchronized void removeFromNode(String node1, InternalTestCluster testCluster) {
        logger.info("stop disrupting node (disruption type: {}, disrupted links: {})", (Object)this.networkLinkDisruptionType, (Object)this.disruptedLinks);
        this.applyToNodes(new String[]{node1}, testCluster.getNodeNames(), this.networkLinkDisruptionType::removeDisruption);
        this.applyToNodes(testCluster.getNodeNames(), new String[]{node1}, this.networkLinkDisruptionType::removeDisruption);
    }

    @Override
    public synchronized void testClusterClosed() {
    }

    @Override
    public synchronized void startDisrupting() {
        logger.info("start disrupting (disruption type: {}, disrupted links: {})", (Object)this.networkLinkDisruptionType, (Object)this.disruptedLinks);
        this.applyToNodes(this.cluster.getNodeNames(), this.cluster.getNodeNames(), this.networkLinkDisruptionType::applyDisruption);
        this.activeDisruption = true;
    }

    @Override
    public synchronized void stopDisrupting() {
        if (!this.activeDisruption) {
            return;
        }
        logger.info("stop disrupting (disruption scheme: {}, disrupted links: {})", (Object)this.networkLinkDisruptionType, (Object)this.disruptedLinks);
        this.applyToNodes(this.cluster.getNodeNames(), this.cluster.getNodeNames(), this.networkLinkDisruptionType::removeDisruption);
        this.activeDisruption = false;
    }

    private void applyToNodes(String[] nodes1, String[] nodes2, BiConsumer<MockTransportService, MockTransportService> consumer) {
        for (String node1 : nodes1) {
            if (!this.disruptedLinks.nodes().contains(node1)) continue;
            for (String node2 : nodes2) {
                if (!this.disruptedLinks.nodes().contains(node2) || node1.equals(node2) || !this.disruptedLinks.disrupt(node1, node2)) continue;
                consumer.accept(this.transport(node1), this.transport(node2));
            }
        }
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return this.networkLinkDisruptionType.expectedTimeToHeal();
    }

    private MockTransportService transport(String node) {
        return (MockTransportService)this.cluster.getInstance(TransportService.class, node);
    }

    public String toString() {
        return "network disruption (disruption type: " + String.valueOf(this.networkLinkDisruptionType) + ", disrupted links: " + String.valueOf(this.disruptedLinks) + ")";
    }

    public static abstract class DisruptedLinks {
        private final Set<String> nodes;

        @SafeVarargs
        protected DisruptedLinks(Set<String> ... nodeSets) {
            HashSet<String> allNodes = new HashSet<String>();
            for (Set<String> nodeSet : nodeSets) {
                allNodes.addAll(nodeSet);
            }
            this.nodes = allNodes;
        }

        public Set<String> nodes() {
            return this.nodes;
        }

        public abstract boolean disrupt(String var1, String var2);
    }

    public static abstract class NetworkLinkDisruptionType {
        public abstract void applyDisruption(MockTransportService var1, MockTransportService var2);

        public void removeDisruption(MockTransportService sourceTransportService, MockTransportService targetTransportService) {
            sourceTransportService.clearOutboundRules(targetTransportService);
        }

        public TimeValue expectedTimeToHeal() {
            return TimeValue.timeValueMillis((long)0L);
        }
    }

    public static class NetworkDelay
    extends NetworkLinkDisruptionType {
        public static TimeValue DEFAULT_DELAY_MIN = TimeValue.timeValueSeconds((long)10L);
        public static TimeValue DEFAULT_DELAY_MAX = TimeValue.timeValueSeconds((long)90L);
        private final TimeValue delay;

        public NetworkDelay(TimeValue delay) {
            this.delay = delay;
        }

        public static NetworkDelay random(Random random) {
            return NetworkDelay.random(random, DEFAULT_DELAY_MIN, DEFAULT_DELAY_MAX);
        }

        public static NetworkDelay random(Random random, TimeValue delayMin, TimeValue delayMax) {
            return new NetworkDelay(TimeValue.timeValueMillis((long)(delayMin.millis() == delayMax.millis() ? delayMin.millis() : delayMin.millis() + (long)random.nextInt((int)(delayMax.millis() - delayMin.millis())))));
        }

        @Override
        public void applyDisruption(MockTransportService sourceTransportService, MockTransportService targetTransportService) {
            sourceTransportService.addUnresponsiveRule(targetTransportService, this.delay);
        }

        @Override
        public TimeValue expectedTimeToHeal() {
            return this.delay;
        }

        public String toString() {
            return "network delays for [" + String.valueOf(this.delay) + "]";
        }
    }

    public static class IsolateAllNodes
    extends DisruptedLinks {
        public IsolateAllNodes(Set<String> nodes) {
            super(nodes);
        }

        @Override
        public boolean disrupt(String node1, String node2) {
            return true;
        }
    }

    public static class Bridge
    extends DisruptedLinks {
        private final String bridgeNode;
        private final Set<String> nodesSideOne;
        private final Set<String> nodesSideTwo;

        public Bridge(String bridgeNode, Set<String> nodesSideOne, Set<String> nodesSideTwo) {
            super(Collections.singleton(bridgeNode), nodesSideOne, nodesSideTwo);
            this.bridgeNode = bridgeNode;
            this.nodesSideOne = nodesSideOne;
            this.nodesSideTwo = nodesSideTwo;
            assert (!nodesSideOne.isEmpty());
            assert (!nodesSideTwo.isEmpty());
            assert (Sets.haveEmptyIntersection(nodesSideOne, nodesSideTwo));
            assert (!nodesSideOne.contains(bridgeNode) && !nodesSideTwo.contains(bridgeNode));
        }

        public static Bridge random(Random random, String ... nodes) {
            return Bridge.random(random, Sets.newHashSet((Object[])nodes));
        }

        public static Bridge random(Random random, Set<String> nodes) {
            assert (nodes.size() >= 3) : "bridge topology requires at least 3 nodes";
            String bridgeNode = (String)RandomPicks.randomFrom((Random)random, nodes);
            HashSet<String> nodesSideOne = new HashSet<String>();
            HashSet<String> nodesSideTwo = new HashSet<String>();
            for (String node : nodes) {
                if (node.equals(bridgeNode)) continue;
                if (nodesSideOne.isEmpty()) {
                    nodesSideOne.add(node);
                    continue;
                }
                if (nodesSideTwo.isEmpty()) {
                    nodesSideTwo.add(node);
                    continue;
                }
                if (random.nextBoolean()) {
                    nodesSideOne.add(node);
                    continue;
                }
                nodesSideTwo.add(node);
            }
            return new Bridge(bridgeNode, nodesSideOne, nodesSideTwo);
        }

        @Override
        public boolean disrupt(String node1, String node2) {
            if (this.nodesSideOne.contains(node1) && this.nodesSideTwo.contains(node2)) {
                return true;
            }
            return this.nodesSideOne.contains(node2) && this.nodesSideTwo.contains(node1);
        }

        public String getBridgeNode() {
            return this.bridgeNode;
        }

        public Set<String> getNodesSideOne() {
            return this.nodesSideOne;
        }

        public Set<String> getNodesSideTwo() {
            return this.nodesSideTwo;
        }

        public String toString() {
            return "bridge partition (super connected node: [" + this.bridgeNode + "], partition 1: " + String.valueOf(this.nodesSideOne) + " and partition 2: " + String.valueOf(this.nodesSideTwo) + ")";
        }
    }

    public static class TwoPartitions
    extends DisruptedLinks {
        protected final Set<String> nodesSideOne;
        protected final Set<String> nodesSideTwo;

        public TwoPartitions(String node1, String node2) {
            this(Collections.singleton(node1), Collections.singleton(node2));
        }

        public TwoPartitions(Set<String> nodesSideOne, Set<String> nodesSideTwo) {
            super(nodesSideOne, nodesSideTwo);
            this.nodesSideOne = nodesSideOne;
            this.nodesSideTwo = nodesSideTwo;
            assert (!nodesSideOne.isEmpty());
            assert (!nodesSideTwo.isEmpty());
            assert (Sets.haveEmptyIntersection(nodesSideOne, nodesSideTwo));
        }

        public static TwoPartitions random(Random random, String ... nodes) {
            return TwoPartitions.random(random, Sets.newHashSet((Object[])nodes));
        }

        public static TwoPartitions random(Random random, Set<String> nodes) {
            assert (nodes.size() >= 2) : "two partitions topology requires at least 2 nodes";
            HashSet<String> nodesSideOne = new HashSet<String>();
            HashSet<String> nodesSideTwo = new HashSet<String>();
            for (String node : nodes) {
                if (nodesSideOne.isEmpty()) {
                    nodesSideOne.add(node);
                    continue;
                }
                if (nodesSideTwo.isEmpty()) {
                    nodesSideTwo.add(node);
                    continue;
                }
                if (random.nextBoolean()) {
                    nodesSideOne.add(node);
                    continue;
                }
                nodesSideTwo.add(node);
            }
            return new TwoPartitions((Set<String>)nodesSideOne, (Set<String>)nodesSideTwo);
        }

        @Override
        public boolean disrupt(String node1, String node2) {
            if (this.nodesSideOne.contains(node1) && this.nodesSideTwo.contains(node2)) {
                return true;
            }
            return this.nodesSideOne.contains(node2) && this.nodesSideTwo.contains(node1);
        }

        public Set<String> getNodesSideOne() {
            return Collections.unmodifiableSet(this.nodesSideOne);
        }

        public Set<String> getNodesSideTwo() {
            return Collections.unmodifiableSet(this.nodesSideTwo);
        }

        public Collection<String> getMajoritySide() {
            if (this.nodesSideOne.size() >= this.nodesSideTwo.size()) {
                return this.getNodesSideOne();
            }
            return this.getNodesSideTwo();
        }

        public Collection<String> getMinoritySide() {
            if (this.nodesSideOne.size() >= this.nodesSideTwo.size()) {
                return this.getNodesSideTwo();
            }
            return this.getNodesSideOne();
        }

        public String toString() {
            return "two partitions (partition 1: " + String.valueOf(this.nodesSideOne) + " and partition 2: " + String.valueOf(this.nodesSideTwo) + ")";
        }
    }
}

