/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Nullable;

public class VersionUtils {
    private static final List<Version> ALL_VERSIONS = Version.getDeclaredVersions(Version.class);

    public static List<Version> allVersions() {
        return ALL_VERSIONS;
    }

    public static Version getPreviousVersion(Version version) {
        for (int i = ALL_VERSIONS.size() - 1; i >= 0; --i) {
            Version v = ALL_VERSIONS.get(i);
            if (!v.before((VersionId)version)) continue;
            return v;
        }
        throw new IllegalArgumentException("couldn't find any versions before [" + String.valueOf(version) + "]");
    }

    public static Version getPreviousVersion() {
        Version version = VersionUtils.getPreviousVersion(Version.CURRENT);
        assert (version.before((VersionId)Version.CURRENT));
        return version;
    }

    public static Version getPreviousMinorVersion() {
        for (int i = ALL_VERSIONS.size() - 1; i >= 0; --i) {
            Version v = ALL_VERSIONS.get(i);
            if (v.minor >= Version.CURRENT.minor && v.major >= Version.CURRENT.major) continue;
            return v;
        }
        throw new IllegalArgumentException("couldn't find any versions of the minor before [" + Build.current().version() + "]");
    }

    public static Version getFirstVersion() {
        return ALL_VERSIONS.get(0);
    }

    public static Version randomVersion(Random random) {
        return ALL_VERSIONS.get(random.nextInt(ALL_VERSIONS.size()));
    }

    public static Version randomCompatibleVersion(Random random, Version version) {
        List<Version> compatible = ALL_VERSIONS.stream().filter(arg_0 -> ((Version)version).isCompatible(arg_0)).toList();
        return compatible.get(random.nextInt(compatible.size()));
    }

    public static Version randomVersionBetween(Random random, @Nullable Version minVersion, @Nullable Version maxVersion) {
        int minVersionIndex = 0;
        if (minVersion != null) {
            minVersionIndex = ALL_VERSIONS.indexOf(minVersion);
        }
        int maxVersionIndex = ALL_VERSIONS.size() - 1;
        if (maxVersion != null) {
            maxVersionIndex = ALL_VERSIONS.indexOf(maxVersion);
        }
        if (minVersionIndex == -1) {
            throw new IllegalArgumentException("minVersion [" + String.valueOf(minVersion) + "] does not exist.");
        }
        if (maxVersionIndex == -1) {
            throw new IllegalArgumentException("maxVersion [" + String.valueOf(maxVersion) + "] does not exist.");
        }
        if (minVersionIndex > maxVersionIndex) {
            throw new IllegalArgumentException("maxVersion [" + String.valueOf(maxVersion) + "] cannot be less than minVersion [" + String.valueOf(minVersion) + "]");
        }
        int range = maxVersionIndex + 1 - minVersionIndex;
        return ALL_VERSIONS.get(minVersionIndex + random.nextInt(range));
    }

    public static Version compatibleFutureVersion(Version version) {
        Optional<Version> opt = ALL_VERSIONS.stream().filter(arg_0 -> ((Version)version).before(arg_0)).filter(v -> v.isCompatible(version)).findAny();
        assert (opt.isPresent()) : "no future compatible version for " + String.valueOf(version);
        return opt.get();
    }

    public static Version maxCompatibleVersion(Version version) {
        List<Version> compatible = ALL_VERSIONS.stream().filter(arg_0 -> ((Version)version).isCompatible(arg_0)).filter(arg_0 -> ((Version)version).onOrBefore(arg_0)).toList();
        assert (compatible.size() > 0);
        return compatible.get(compatible.size() - 1);
    }
}

