/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.template.delete.TransportDeleteComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.TransportDeleteComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetComposableIndexTemplateAction;
import org.elasticsearch.action.datastreams.DeleteDataStreamAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;

public abstract class TestCluster {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final long seed;
    protected Random random;

    public TestCluster(long seed) {
        this.seed = seed;
    }

    public long seed() {
        return this.seed;
    }

    public void beforeTest(Random randomGenerator) throws IOException, InterruptedException {
        this.random = new Random(randomGenerator.nextLong());
    }

    public void wipe(Set<String> excludeTemplates) {
        if (this.size() == 0) {
            return;
        }
        ESTestCase.safeAwait(done -> {
            try (RefCountingListener listeners = new RefCountingListener(done);){
                this.wipeAllTemplates(excludeTemplates, listeners);
                SubscribableListener.newForked(l -> this.client().execute((ActionType)DeleteDataStreamAction.INSTANCE, (ActionRequest)new DeleteDataStreamAction.Request(ESTestCase.TEST_REQUEST_TIMEOUT, new String[]{"*"}).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN), l.delegateResponse((ll, e) -> {
                    if (!Objects.requireNonNullElse(e.getMessage(), "").startsWith("failed to find action")) {
                        ll.onFailure(e);
                    } else {
                        ll.onResponse((Object)AcknowledgedResponse.TRUE);
                    }
                }))).andThenAccept(ElasticsearchAssertions::assertAcked).andThenAccept(v -> {
                    SubscribableListener.newForked(ll -> this.wipeIndicesAsync(new String[]{"_all"}, (ActionListener<Void>)ll)).andThen(this::wipeRepositories).addListener(listeners.acquire());
                    this.deleteTemplates(excludeTemplates, (ActionListener<Void>)listeners.acquire());
                }).addListener(listeners.acquire());
            }
        });
    }

    private void deleteTemplates(Set<String> excludeTemplates, ActionListener<Void> listener) {
        SubscribableListener getComposableTemplates = SubscribableListener.newForked(l -> this.client().execute((ActionType)GetComposableIndexTemplateAction.INSTANCE, (ActionRequest)new GetComposableIndexTemplateAction.Request("*"), l));
        SubscribableListener getComponentTemplates = SubscribableListener.newForked(l -> this.client().execute((ActionType)GetComponentTemplateAction.INSTANCE, (ActionRequest)new GetComponentTemplateAction.Request("*"), l));
        SubscribableListener.nullSuccess().andThen(arg_0 -> ((SubscribableListener)getComposableTemplates).addListener(arg_0)).andThen((l, r) -> {
            String[] templates = (String[])r.indexTemplates().keySet().stream().filter(template -> !excludeTemplates.contains(template)).toArray(String[]::new);
            if (templates.length == 0) {
                l.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                TransportDeleteComposableIndexTemplateAction.Request request = new TransportDeleteComposableIndexTemplateAction.Request(templates);
                this.client().execute(TransportDeleteComposableIndexTemplateAction.TYPE, (ActionRequest)request, l);
            }
        }).andThenAccept(ElasticsearchAssertions::assertAcked).andThen(arg_0 -> ((SubscribableListener)getComponentTemplates).addListener(arg_0)).andThen((l, response) -> {
            String[] componentTemplates = (String[])response.getComponentTemplates().keySet().stream().filter(template -> !excludeTemplates.contains(template)).toArray(String[]::new);
            if (componentTemplates.length == 0) {
                l.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                this.client().execute(TransportDeleteComponentTemplateAction.TYPE, (ActionRequest)new TransportDeleteComponentTemplateAction.Request(componentTemplates), l);
            }
        }).andThenAccept(ElasticsearchAssertions::assertAcked).addListener(listener);
    }

    public void beforeIndexDeletion() throws Exception {
    }

    public void assertAfterTest() throws Exception {
        this.ensureEstimatedStats();
    }

    public abstract void afterTest() throws IOException;

    public abstract Client client();

    public abstract int size();

    public abstract int numDataNodes();

    public abstract int numDataAndMasterNodes();

    public abstract InetSocketAddress[] httpAddresses();

    public abstract void close() throws IOException;

    public void wipeIndices(String ... indices) {
        ESTestCase.safeAwait(l -> this.wipeIndicesAsync(indices, (ActionListener<Void>)l));
    }

    private void wipeIndicesAsync(String[] indices, ActionListener<Void> listener) {
        assert (indices != null && indices.length > 0);
        SubscribableListener.newForked(l -> this.client().admin().indices().prepareDelete(indices).setIndicesOptions(IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false)).execute(l.delegateResponse((ll, exception) -> this.handleWipeIndicesFailure((Exception)exception, "_all".equals(indices[0]), (ActionListener<AcknowledgedResponse>)ll)))).andThenAccept(ElasticsearchAssertions::assertAcked).addListener(listener);
    }

    private void handleWipeIndicesFailure(Exception exception, boolean wipingAllIndices, ActionListener<AcknowledgedResponse> listener) {
        Throwable unwrapped = ExceptionsHelper.unwrap((Throwable)exception, (Class[])new Class[]{IndexNotFoundException.class, IllegalArgumentException.class});
        if (unwrapped instanceof IndexNotFoundException) {
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        } else if (unwrapped instanceof IllegalArgumentException) {
            if (wipingAllIndices) {
                SubscribableListener.newForked(l -> this.client().admin().cluster().prepareState(ESTestCase.TEST_REQUEST_TIMEOUT).execute(l)).andThen((l, clusterStateResponse) -> {
                    ArrayList<String> concreteIndices = new ArrayList<String>();
                    for (IndexMetadata indexMetadata : clusterStateResponse.getState().metadata()) {
                        concreteIndices.add(indexMetadata.getIndex().getName());
                    }
                    if (!concreteIndices.isEmpty()) {
                        this.client().admin().indices().prepareDelete(concreteIndices.toArray(Strings.EMPTY_ARRAY)).execute(l);
                    } else {
                        l.onResponse((Object)AcknowledgedResponse.TRUE);
                    }
                }).addListener(listener);
            } else {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
        } else {
            listener.onFailure(exception);
        }
    }

    private void wipeAllTemplates(Set<String> exclude, RefCountingListener listeners) {
        SubscribableListener.newForked(l -> this.client().admin().indices().prepareGetTemplates(new String[0]).execute(l)).andThenAccept(response -> {
            for (IndexTemplateMetadata indexTemplate : response.getIndexTemplates()) {
                if (exclude.contains(indexTemplate.getName())) continue;
                this.client().admin().indices().prepareDeleteTemplate(indexTemplate.getName()).execute(listeners.acquire(ElasticsearchAssertions::assertAcked).delegateResponse((l, e) -> {
                    if (e instanceof IndexTemplateMissingException) {
                        l.onResponse((Object)AcknowledgedResponse.TRUE);
                    } else {
                        l.onFailure(e);
                    }
                }));
            }
        }).addListener(listeners.acquire());
    }

    public void wipeTemplates(String ... templates) {
        if (this.size() > 0) {
            if (templates.length == 0) {
                templates = new String[]{"*"};
            }
            for (String template : templates) {
                try {
                    this.client().admin().indices().prepareDeleteTemplate(template).get();
                }
                catch (IndexTemplateMissingException indexTemplateMissingException) {
                    // empty catch block
                }
            }
        }
    }

    private void wipeRepositories(ActionListener<Void> listener) {
        SubscribableListener.newForked(l -> this.client().admin().cluster().prepareDeleteRepository(ESTestCase.TEST_REQUEST_TIMEOUT, ESTestCase.TEST_REQUEST_TIMEOUT, "*").execute(l.delegateResponse((ll, e) -> {
            if (e instanceof RepositoryMissingException) {
                l.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                l.onFailure(e);
            }
        }))).andThenAccept(ElasticsearchAssertions::assertAcked).addListener(listener);
    }

    public abstract void ensureEstimatedStats();

    public abstract String getClusterName();

    public abstract Iterable<Client> getClients();

    public abstract NamedWriteableRegistry getNamedWriteableRegistry();
}

