/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.cli.Terminal;

public class MockTerminal
extends Terminal {
    private static final byte[] NEWLINE = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
    private final ResettableInputStreamReader stdinReader;
    private final LazyByteArrayInputStream stdinBuffer;
    private final ByteArrayOutputStream stdoutBuffer;
    private final ByteArrayOutputStream stderrBuffer;
    private boolean supportsBinary = false;

    private MockTerminal(ResettableInputStreamReader stdinReader, ByteArrayOutputStream stdout, ByteArrayOutputStream stderr) {
        super((Reader)stdinReader, MockTerminal.newPrintWriter(stdout), MockTerminal.newPrintWriter(stderr));
        this.stdinReader = stdinReader;
        this.stdinBuffer = stdinReader.stream;
        this.stdoutBuffer = stdout;
        this.stderrBuffer = stderr;
    }

    public InputStream getInputStream() {
        return this.supportsBinary ? this.stdinBuffer : null;
    }

    public OutputStream getOutputStream() {
        return this.supportsBinary ? this.stdoutBuffer : null;
    }

    private static PrintWriter newPrintWriter(OutputStream out) {
        return new PrintWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), true);
    }

    public static MockTerminal create() {
        ResettableInputStreamReader reader = new ResettableInputStreamReader(new LazyByteArrayInputStream());
        return new MockTerminal(reader, new ByteArrayOutputStream(), new ByteArrayOutputStream());
    }

    public void addTextInput(String input) {
        this.stdinBuffer.append(input.getBytes(StandardCharsets.UTF_8));
        this.stdinBuffer.append(NEWLINE);
    }

    public void addSecretInput(String input) {
        this.addTextInput(input);
    }

    public void addBinaryInput(byte[] bytes) {
        this.stdinBuffer.append(bytes);
    }

    public String getOutput() {
        return this.stdoutBuffer.toString(StandardCharsets.UTF_8);
    }

    public byte[] getOutputBytes() {
        return this.stdoutBuffer.toByteArray();
    }

    public String getErrorOutput() {
        return this.stderrBuffer.toString(StandardCharsets.UTF_8);
    }

    public void setSupportsBinary(boolean supportsBinary) {
        this.supportsBinary = supportsBinary;
    }

    public void reset() {
        this.stdinBuffer.clear();
        this.stdinReader.reset();
        this.stdoutBuffer.reset();
        this.stderrBuffer.reset();
    }

    static class ResettableInputStreamReader
    extends FilterReader {
        final LazyByteArrayInputStream stream;

        private ResettableInputStreamReader(LazyByteArrayInputStream stream) {
            super(ResettableInputStreamReader.createReader(stream));
            this.stream = stream;
        }

        static InputStreamReader createReader(InputStream stream) {
            return new InputStreamReader(stream, StandardCharsets.UTF_8);
        }

        @Override
        public void reset() {
            this.in = ResettableInputStreamReader.createReader(this.stream);
        }
    }

    private static class LazyByteArrayInputStream
    extends ByteArrayInputStream {
        LazyByteArrayInputStream() {
            super(new byte[128], 0, 0);
        }

        void append(byte[] bytes) {
            int availableSpace = this.buf.length - this.count;
            if (bytes.length > availableSpace) {
                int remaining = this.count - this.pos;
                int newSize = Math.max(this.buf.length * 2, remaining + bytes.length);
                byte[] newBuf = new byte[newSize];
                System.arraycopy(this.buf, this.pos, newBuf, 0, remaining);
                this.buf = newBuf;
                this.pos = 0;
                this.count = remaining;
            }
            System.arraycopy(bytes, 0, this.buf, this.count, bytes.length);
            this.count += bytes.length;
        }

        void clear() {
            this.pos = 0;
            this.count = 0;
        }
    }
}

