/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.h3;

import java.util.Objects;
import org.elasticsearch.h3.Constants;
import org.elasticsearch.h3.FastMath;
import org.elasticsearch.h3.Vec2d;

public final class LatLng {
    private static final double MINIMUM_ANGULAR_RESOLUTION = 3.141592653589793E-12;
    private static final double M_PI_2 = 1.5707963267948966;
    private final double lon;
    private final double lat;

    LatLng(double lat, double lon) {
        this.lon = lon;
        this.lat = lat;
    }

    public double getLatRad() {
        return this.lat;
    }

    public double getLonRad() {
        return this.lon;
    }

    public double getLatDeg() {
        return Math.toDegrees(this.getLatRad());
    }

    public double getLonDeg() {
        return Math.toDegrees(this.getLonRad());
    }

    double geoAzimuthRads(double lat, double lon) {
        double cosLat = FastMath.cos(lat);
        return FastMath.atan2(cosLat * FastMath.sin(lon - this.lon), FastMath.cos(this.lat) * FastMath.sin(lat) - FastMath.sin(this.lat) * cosLat * FastMath.cos(lon - this.lon));
    }

    LatLng geoAzDistanceRads(double az, double distance) {
        double cosP1Lat;
        az = Vec2d.posAngleRads(az);
        double sinDistance = FastMath.sin(distance);
        double cosDistance = FastMath.cos(distance);
        double sinP1Lat = FastMath.sin(this.getLatRad());
        double sinlat = Math.max(-1.0, Math.min(1.0, sinP1Lat * cosDistance + (cosP1Lat = FastMath.cos(this.getLatRad())) * sinDistance * FastMath.cos(az)));
        double lat = FastMath.asin(sinlat);
        if (Math.abs(lat - 1.5707963267948966) < Constants.EPSILON) {
            return new LatLng(1.5707963267948966, 0.0);
        }
        if (Math.abs(lat + 1.5707963267948966) < Constants.EPSILON) {
            return new LatLng(-1.5707963267948966, 0.0);
        }
        double cosLat = FastMath.cos(lat);
        double sinlng = Math.max(-1.0, Math.min(1.0, FastMath.sin(az) * sinDistance / cosLat));
        double coslng = Math.max(-1.0, Math.min(1.0, (cosDistance - sinP1Lat * FastMath.sin(lat)) / cosP1Lat / cosLat));
        return new LatLng(lat, LatLng.constrainLng(this.getLonRad() + FastMath.atan2(sinlng, coslng)));
    }

    private static double constrainLng(double lng) {
        while (lng > Math.PI) {
            lng -= Math.PI * 2;
        }
        while (lng < -Math.PI) {
            lng += Math.PI * 2;
        }
        return lng;
    }

    public double greatCircleMaxLatitude(LatLng latLng) {
        if (this.isNumericallyIdentical(latLng)) {
            return latLng.lat;
        }
        return latLng.lat > this.lat ? LatLng.greatCircleMaxLatitude(latLng, this) : LatLng.greatCircleMaxLatitude(this, latLng);
    }

    private static double greatCircleMaxLatitude(LatLng latLng1, LatLng latLng2) {
        assert (latLng1.lat >= latLng2.lat);
        double az = latLng1.geoAzimuthRads(latLng2.lat, latLng2.lon);
        if (Math.abs(az) < 1.5707963267948966) {
            return FastMath.acos(Math.abs(FastMath.sin(az) * FastMath.cos(latLng1.lat)));
        }
        return latLng1.lat;
    }

    public double greatCircleMinLatitude(LatLng latLng) {
        if (this.isNumericallyIdentical(latLng)) {
            return latLng.lat;
        }
        return latLng.lat < this.lat ? LatLng.greatCircleMinLatitude(latLng, this) : LatLng.greatCircleMinLatitude(this, latLng);
    }

    private static double greatCircleMinLatitude(LatLng latLng1, LatLng latLng2) {
        assert (latLng1.lat <= latLng2.lat);
        double az = latLng1.geoAzimuthRads(latLng2.lat, latLng2.lon);
        if (Math.abs(az) > 1.5707963267948966) {
            return -FastMath.acos(Math.abs(FastMath.sin(az) * FastMath.cos(latLng1.lat)));
        }
        return latLng1.lat;
    }

    boolean isNumericallyIdentical(LatLng latLng) {
        return Math.abs(this.lat - latLng.lat) < 3.141592653589793E-12 && Math.abs(this.lon - latLng.lon) < 3.141592653589793E-12;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLng latLng = (LatLng)o;
        return Double.compare(latLng.lon, this.lon) == 0 && Double.compare(latLng.lat, this.lat) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.lon, this.lat);
    }
}

