/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityBlockInterconnectStatus;
import software.amazon.awssdk.services.ec2.model.CapacityReservationStatus;
import software.amazon.awssdk.services.ec2.model.CapacityReservationStatusSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityBlockStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityBlockStatus> {
    private static final SdkField<String> CAPACITY_BLOCK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityBlockId").getter(CapacityBlockStatus.getter(CapacityBlockStatus::capacityBlockId)).setter(CapacityBlockStatus.setter(Builder::capacityBlockId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockId").unmarshallLocationName("capacityBlockId").build()}).build();
    private static final SdkField<String> INTERCONNECT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterconnectStatus").getter(CapacityBlockStatus.getter(CapacityBlockStatus::interconnectStatusAsString)).setter(CapacityBlockStatus.setter(Builder::interconnectStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterconnectStatus").unmarshallLocationName("interconnectStatus").build()}).build();
    private static final SdkField<Integer> TOTAL_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCapacity").getter(CapacityBlockStatus.getter(CapacityBlockStatus::totalCapacity)).setter(CapacityBlockStatus.setter(Builder::totalCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCapacity").unmarshallLocationName("totalCapacity").build()}).build();
    private static final SdkField<Integer> TOTAL_AVAILABLE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalAvailableCapacity").getter(CapacityBlockStatus.getter(CapacityBlockStatus::totalAvailableCapacity)).setter(CapacityBlockStatus.setter(Builder::totalAvailableCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAvailableCapacity").unmarshallLocationName("totalAvailableCapacity").build()}).build();
    private static final SdkField<Integer> TOTAL_UNAVAILABLE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalUnavailableCapacity").getter(CapacityBlockStatus.getter(CapacityBlockStatus::totalUnavailableCapacity)).setter(CapacityBlockStatus.setter(Builder::totalUnavailableCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalUnavailableCapacity").unmarshallLocationName("totalUnavailableCapacity").build()}).build();
    private static final SdkField<List<CapacityReservationStatus>> CAPACITY_RESERVATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservationStatuses").getter(CapacityBlockStatus.getter(CapacityBlockStatus::capacityReservationStatuses)).setter(CapacityBlockStatus.setter(Builder::capacityReservationStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationStatusSet").unmarshallLocationName("capacityReservationStatusSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityReservationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_BLOCK_ID_FIELD, INTERCONNECT_STATUS_FIELD, TOTAL_CAPACITY_FIELD, TOTAL_AVAILABLE_CAPACITY_FIELD, TOTAL_UNAVAILABLE_CAPACITY_FIELD, CAPACITY_RESERVATION_STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityBlockStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityBlockId;
    private final String interconnectStatus;
    private final Integer totalCapacity;
    private final Integer totalAvailableCapacity;
    private final Integer totalUnavailableCapacity;
    private final List<CapacityReservationStatus> capacityReservationStatuses;

    private CapacityBlockStatus(BuilderImpl builder) {
        this.capacityBlockId = builder.capacityBlockId;
        this.interconnectStatus = builder.interconnectStatus;
        this.totalCapacity = builder.totalCapacity;
        this.totalAvailableCapacity = builder.totalAvailableCapacity;
        this.totalUnavailableCapacity = builder.totalUnavailableCapacity;
        this.capacityReservationStatuses = builder.capacityReservationStatuses;
    }

    public final String capacityBlockId() {
        return this.capacityBlockId;
    }

    public final CapacityBlockInterconnectStatus interconnectStatus() {
        return CapacityBlockInterconnectStatus.fromValue(this.interconnectStatus);
    }

    public final String interconnectStatusAsString() {
        return this.interconnectStatus;
    }

    public final Integer totalCapacity() {
        return this.totalCapacity;
    }

    public final Integer totalAvailableCapacity() {
        return this.totalAvailableCapacity;
    }

    public final Integer totalUnavailableCapacity() {
        return this.totalUnavailableCapacity;
    }

    public final boolean hasCapacityReservationStatuses() {
        return this.capacityReservationStatuses != null && !(this.capacityReservationStatuses instanceof SdkAutoConstructList);
    }

    public final List<CapacityReservationStatus> capacityReservationStatuses() {
        return this.capacityReservationStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAvailableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalUnavailableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityReservationStatuses() ? this.capacityReservationStatuses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityBlockStatus)) {
            return false;
        }
        CapacityBlockStatus other = (CapacityBlockStatus)obj;
        return Objects.equals(this.capacityBlockId(), other.capacityBlockId()) && Objects.equals(this.interconnectStatusAsString(), other.interconnectStatusAsString()) && Objects.equals(this.totalCapacity(), other.totalCapacity()) && Objects.equals(this.totalAvailableCapacity(), other.totalAvailableCapacity()) && Objects.equals(this.totalUnavailableCapacity(), other.totalUnavailableCapacity()) && this.hasCapacityReservationStatuses() == other.hasCapacityReservationStatuses() && Objects.equals(this.capacityReservationStatuses(), other.capacityReservationStatuses());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityBlockStatus").add("CapacityBlockId", (Object)this.capacityBlockId()).add("InterconnectStatus", (Object)this.interconnectStatusAsString()).add("TotalCapacity", (Object)this.totalCapacity()).add("TotalAvailableCapacity", (Object)this.totalAvailableCapacity()).add("TotalUnavailableCapacity", (Object)this.totalUnavailableCapacity()).add("CapacityReservationStatuses", this.hasCapacityReservationStatuses() ? this.capacityReservationStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityBlockId": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockId()));
            }
            case "InterconnectStatus": {
                return Optional.ofNullable(clazz.cast(this.interconnectStatusAsString()));
            }
            case "TotalCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalCapacity()));
            }
            case "TotalAvailableCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalAvailableCapacity()));
            }
            case "TotalUnavailableCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalUnavailableCapacity()));
            }
            case "CapacityReservationStatuses": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationStatuses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityBlockId", CAPACITY_BLOCK_ID_FIELD);
        map.put("InterconnectStatus", INTERCONNECT_STATUS_FIELD);
        map.put("TotalCapacity", TOTAL_CAPACITY_FIELD);
        map.put("TotalAvailableCapacity", TOTAL_AVAILABLE_CAPACITY_FIELD);
        map.put("TotalUnavailableCapacity", TOTAL_UNAVAILABLE_CAPACITY_FIELD);
        map.put("CapacityReservationStatusSet", CAPACITY_RESERVATION_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityBlockStatus, T> g) {
        return obj -> g.apply((CapacityBlockStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityBlockId;
        private String interconnectStatus;
        private Integer totalCapacity;
        private Integer totalAvailableCapacity;
        private Integer totalUnavailableCapacity;
        private List<CapacityReservationStatus> capacityReservationStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityBlockStatus model) {
            this.capacityBlockId(model.capacityBlockId);
            this.interconnectStatus(model.interconnectStatus);
            this.totalCapacity(model.totalCapacity);
            this.totalAvailableCapacity(model.totalAvailableCapacity);
            this.totalUnavailableCapacity(model.totalUnavailableCapacity);
            this.capacityReservationStatuses(model.capacityReservationStatuses);
        }

        public final String getCapacityBlockId() {
            return this.capacityBlockId;
        }

        public final void setCapacityBlockId(String capacityBlockId) {
            this.capacityBlockId = capacityBlockId;
        }

        @Override
        public final Builder capacityBlockId(String capacityBlockId) {
            this.capacityBlockId = capacityBlockId;
            return this;
        }

        public final String getInterconnectStatus() {
            return this.interconnectStatus;
        }

        public final void setInterconnectStatus(String interconnectStatus) {
            this.interconnectStatus = interconnectStatus;
        }

        @Override
        public final Builder interconnectStatus(String interconnectStatus) {
            this.interconnectStatus = interconnectStatus;
            return this;
        }

        @Override
        public final Builder interconnectStatus(CapacityBlockInterconnectStatus interconnectStatus) {
            this.interconnectStatus(interconnectStatus == null ? null : interconnectStatus.toString());
            return this;
        }

        public final Integer getTotalCapacity() {
            return this.totalCapacity;
        }

        public final void setTotalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
        }

        @Override
        public final Builder totalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
            return this;
        }

        public final Integer getTotalAvailableCapacity() {
            return this.totalAvailableCapacity;
        }

        public final void setTotalAvailableCapacity(Integer totalAvailableCapacity) {
            this.totalAvailableCapacity = totalAvailableCapacity;
        }

        @Override
        public final Builder totalAvailableCapacity(Integer totalAvailableCapacity) {
            this.totalAvailableCapacity = totalAvailableCapacity;
            return this;
        }

        public final Integer getTotalUnavailableCapacity() {
            return this.totalUnavailableCapacity;
        }

        public final void setTotalUnavailableCapacity(Integer totalUnavailableCapacity) {
            this.totalUnavailableCapacity = totalUnavailableCapacity;
        }

        @Override
        public final Builder totalUnavailableCapacity(Integer totalUnavailableCapacity) {
            this.totalUnavailableCapacity = totalUnavailableCapacity;
            return this;
        }

        public final List<CapacityReservationStatus.Builder> getCapacityReservationStatuses() {
            List<CapacityReservationStatus.Builder> result = CapacityReservationStatusSetCopier.copyToBuilder(this.capacityReservationStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservationStatuses(Collection<CapacityReservationStatus.BuilderImpl> capacityReservationStatuses) {
            this.capacityReservationStatuses = CapacityReservationStatusSetCopier.copyFromBuilder(capacityReservationStatuses);
        }

        @Override
        public final Builder capacityReservationStatuses(Collection<CapacityReservationStatus> capacityReservationStatuses) {
            this.capacityReservationStatuses = CapacityReservationStatusSetCopier.copy(capacityReservationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationStatuses(CapacityReservationStatus ... capacityReservationStatuses) {
            this.capacityReservationStatuses(Arrays.asList(capacityReservationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationStatuses(Consumer<CapacityReservationStatus.Builder> ... capacityReservationStatuses) {
            this.capacityReservationStatuses(Stream.of(capacityReservationStatuses).map(c -> (CapacityReservationStatus)((CapacityReservationStatus.Builder)CapacityReservationStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CapacityBlockStatus build() {
            return new CapacityBlockStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityBlockStatus> {
        public Builder capacityBlockId(String var1);

        public Builder interconnectStatus(String var1);

        public Builder interconnectStatus(CapacityBlockInterconnectStatus var1);

        public Builder totalCapacity(Integer var1);

        public Builder totalAvailableCapacity(Integer var1);

        public Builder totalUnavailableCapacity(Integer var1);

        public Builder capacityReservationStatuses(Collection<CapacityReservationStatus> var1);

        public Builder capacityReservationStatuses(CapacityReservationStatus ... var1);

        public Builder capacityReservationStatuses(Consumer<CapacityReservationStatus.Builder> ... var1);
    }
}

