/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeRoleSettings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class DesiredNode
implements Writeable,
ToXContentObject,
Comparable<DesiredNode> {
    public static final NodeFeature RANGE_FLOAT_PROCESSORS_SUPPORTED = new NodeFeature("desired_node.range_float_processors");
    public static final NodeFeature DOUBLE_PROCESSORS_SUPPORTED = new NodeFeature("desired_node.double_processors");
    public static final NodeFeature DESIRED_NODE_VERSION_DEPRECATED = new NodeFeature("desired_node.version_deprecated", true);
    public static final TransportVersion RANGE_FLOAT_PROCESSORS_SUPPORT_TRANSPORT_VERSION = TransportVersions.V_8_3_0;
    private static final ParseField SETTINGS_FIELD = new ParseField("settings", new String[0]);
    private static final ParseField PROCESSORS_FIELD = new ParseField("processors", new String[0]);
    private static final ParseField PROCESSORS_RANGE_FIELD = new ParseField("processors_range", new String[0]);
    private static final ParseField MEMORY_FIELD = new ParseField("memory", new String[0]);
    private static final ParseField STORAGE_FIELD = new ParseField("storage", new String[0]);
    private static final ParseField VERSION_FIELD = new ParseField("node_version", new String[0]);
    public static final ConstructingObjectParser<DesiredNode, Void> PARSER = new ConstructingObjectParser<DesiredNode, Void>("desired_node", false, (args, name) -> new DesiredNode((Settings)args[0], (Processors)args[1], (ProcessorsRange)args[2], (ByteSizeValue)args[3], (ByteSizeValue)args[4], (String)args[5]));
    private final Settings settings;
    private final Processors processors;
    private final ProcessorsRange processorsRange;
    private final ByteSizeValue memory;
    private final ByteSizeValue storage;
    private final String version;
    private final String externalId;
    private final Set<DiscoveryNodeRole> roles;
    private static final Pattern SEMANTIC_VERSION_PATTERN;

    static <T> void configureParser(ConstructingObjectParser<T, Void> parser) {
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), SETTINGS_FIELD);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Processors.fromXContent(p), PROCESSORS_FIELD, ObjectParser.ValueType.DOUBLE);
        parser.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ProcessorsRange.fromXContent(p), null, PROCESSORS_RANGE_FIELD);
        parser.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MEMORY_FIELD.getPreferredName()), MEMORY_FIELD, ObjectParser.ValueType.STRING);
        parser.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), STORAGE_FIELD.getPreferredName()), STORAGE_FIELD, ObjectParser.ValueType.STRING);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), VERSION_FIELD, ObjectParser.ValueType.STRING);
    }

    @Deprecated
    public DesiredNode(Settings settings, ProcessorsRange processorsRange, ByteSizeValue memory, ByteSizeValue storage, String version) {
        this(settings, null, processorsRange, memory, storage, version);
    }

    @Deprecated
    public DesiredNode(Settings settings, double processors, ByteSizeValue memory, ByteSizeValue storage, String version) {
        this(settings, Processors.of(processors), null, memory, storage, version);
    }

    public DesiredNode(Settings settings, ProcessorsRange processorsRange, ByteSizeValue memory, ByteSizeValue storage) {
        this(settings, null, processorsRange, memory, storage);
    }

    public DesiredNode(Settings settings, double processors, ByteSizeValue memory, ByteSizeValue storage) {
        this(settings, Processors.of(processors), null, memory, storage);
    }

    DesiredNode(Settings settings, Processors processors, ProcessorsRange processorsRange, ByteSizeValue memory, ByteSizeValue storage) {
        this(settings, processors, processorsRange, memory, storage, null);
    }

    DesiredNode(Settings settings, Processors processors, ProcessorsRange processorsRange, ByteSizeValue memory, ByteSizeValue storage, @Deprecated String version) {
        assert (settings != null);
        assert (memory != null);
        assert (storage != null);
        if (processors == null && processorsRange == null) {
            throw new IllegalArgumentException(PROCESSORS_FIELD.getPreferredName() + " or " + PROCESSORS_RANGE_FIELD.getPreferredName() + " should be specified and none was specified");
        }
        if (processors != null && processorsRange != null) {
            throw new IllegalArgumentException(PROCESSORS_FIELD.getPreferredName() + " and " + PROCESSORS_RANGE_FIELD.getPreferredName() + " were specified, but only one should be specified");
        }
        if (Node.NODE_EXTERNAL_ID_SETTING.get(settings).isBlank()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] or [%s] is missing or empty", Node.NODE_NAME_SETTING.getKey(), Node.NODE_EXTERNAL_ID_SETTING.getKey()));
        }
        this.settings = settings;
        this.processors = processors;
        this.processorsRange = processorsRange;
        this.memory = memory;
        this.storage = storage;
        this.version = version;
        this.externalId = Node.NODE_EXTERNAL_ID_SETTING.get(settings);
        this.roles = Collections.unmodifiableSortedSet(new TreeSet<DiscoveryNodeRole>(DiscoveryNode.getRolesFromSettings(settings)));
    }

    public static DesiredNode readFrom(StreamInput in) throws IOException {
        ProcessorsRange processorsRange;
        Processors processors;
        Settings settings = Settings.readSettingsFromStream(in);
        if (in.getTransportVersion().onOrAfter(RANGE_FLOAT_PROCESSORS_SUPPORT_TRANSPORT_VERSION)) {
            processors = in.readOptionalWriteable(Processors::readFrom);
            processorsRange = in.readOptionalWriteable(ProcessorsRange::readFrom);
        } else {
            processors = Processors.readFrom(in);
            processorsRange = null;
        }
        ByteSizeValue memory = ByteSizeValue.readFrom(in);
        ByteSizeValue storage = ByteSizeValue.readFrom(in);
        String version = in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) ? in.readOptionalString() : Version.readVersion(in).toString();
        return new DesiredNode(settings, processors, processorsRange, memory, storage, version);
    }

    private static Version parseLegacyVersion(String version) {
        Matcher semanticVersionMatcher;
        if (version != null && (semanticVersionMatcher = SEMANTIC_VERSION_PATTERN.matcher(version)).matches()) {
            return Version.fromString(semanticVersionMatcher.group(1));
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.settings.writeTo(out);
        if (out.getTransportVersion().onOrAfter(RANGE_FLOAT_PROCESSORS_SUPPORT_TRANSPORT_VERSION)) {
            out.writeOptionalWriteable(this.processors);
            out.writeOptionalWriteable(this.processorsRange);
        } else {
            assert (this.processorsRange == null);
            assert (this.processors != null);
            this.processors.writeTo(out);
        }
        this.memory.writeTo(out);
        this.storage.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
            out.writeOptionalString(this.version);
        } else {
            Version parsedVersion = DesiredNode.parseLegacyVersion(this.version);
            if (this.version == null) {
                Version.writeVersion(Version.CURRENT, out);
            } else {
                Version.writeVersion(parsedVersion, out);
            }
        }
    }

    public static DesiredNode fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public void toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SETTINGS_FIELD.getPreferredName());
        this.settings.toXContent(builder, params);
        builder.endObject();
        if (this.processors != null) {
            builder.field(PROCESSORS_FIELD.getPreferredName(), this.processors);
        }
        if (this.processorsRange != null) {
            builder.field(PROCESSORS_RANGE_FIELD.getPreferredName(), this.processorsRange);
        }
        builder.field(MEMORY_FIELD.getPreferredName(), this.memory);
        builder.field(STORAGE_FIELD.getPreferredName(), this.storage);
        this.addDeprecatedVersionField(builder);
    }

    private void addDeprecatedVersionField(XContentBuilder builder) throws IOException {
        if (this.version != null) {
            builder.field(VERSION_FIELD.getPreferredName(), this.version);
        }
    }

    public boolean hasMasterRole() {
        return NodeRoleSettings.NODE_ROLES_SETTING.get(this.settings).contains(DiscoveryNodeRole.MASTER_ROLE);
    }

    public Settings settings() {
        return this.settings;
    }

    public Processors minProcessors() {
        if (this.processors != null) {
            return this.processors;
        }
        return this.processorsRange.min();
    }

    public int roundedDownMinProcessors() {
        return this.minProcessors().roundDown();
    }

    @Nullable
    public Processors maxProcessors() {
        if (this.processors != null) {
            return this.processors;
        }
        return this.processorsRange.max();
    }

    public Integer roundedUpMaxProcessors() {
        Processors maxProcessors = this.maxProcessors();
        if (maxProcessors == null) {
            return null;
        }
        return maxProcessors.roundUp();
    }

    @Nullable
    Processors processors() {
        return this.processors;
    }

    @Nullable
    ProcessorsRange processorsRange() {
        return this.processorsRange;
    }

    public ByteSizeValue memory() {
        return this.memory;
    }

    public ByteSizeValue storage() {
        return this.storage;
    }

    public String externalId() {
        return this.externalId;
    }

    public Set<DiscoveryNodeRole> getRoles() {
        return this.roles;
    }

    public boolean clusterHasRequiredFeatures(Predicate<NodeFeature> clusterHasFeature) {
        return this.processorsRange == null && !this.processors.hasDecimals() || clusterHasFeature.test(RANGE_FLOAT_PROCESSORS_SUPPORTED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DesiredNode that = (DesiredNode)o;
        return this.equalsWithoutProcessorsSpecification(that) && Objects.equals(this.processorsRange, that.processorsRange) && Objects.equals(this.processors, that.processors);
    }

    private boolean equalsWithoutProcessorsSpecification(DesiredNode that) {
        return Objects.equals(this.settings, that.settings) && Objects.equals(this.memory, that.memory) && Objects.equals(this.storage, that.storage) && Objects.equals(this.version, that.version) && Objects.equals(this.externalId, that.externalId) && Objects.equals(this.roles, that.roles);
    }

    public boolean equalsWithProcessorsCloseTo(DesiredNode that) {
        return this.equalsWithoutProcessorsSpecification(that) && Processors.equalsOrCloseTo(this.processors, that.processors) && ProcessorsRange.equalsOrCloseTo(this.processorsRange, that.processorsRange);
    }

    public int hashCode() {
        return Objects.hash(this.settings, this.processors, this.processorsRange, this.memory, this.storage, this.version, this.externalId, this.roles);
    }

    @Override
    public int compareTo(DesiredNode o) {
        return this.externalId.compareTo(o.externalId);
    }

    public String toString() {
        return "DesiredNode{settings=" + String.valueOf(this.settings) + ", processors=" + String.valueOf(this.processors) + ", processorsRange=" + String.valueOf(this.processorsRange) + ", memory=" + String.valueOf(this.memory) + ", storage=" + String.valueOf(this.storage) + ", externalId='" + this.externalId + "', roles=" + String.valueOf(this.roles) + "}";
    }

    public boolean hasVersion() {
        return !Strings.isNullOrBlank(this.version);
    }

    static {
        DesiredNode.configureParser(PARSER);
        SEMANTIC_VERSION_PATTERN = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)\\D?.*");
    }

    public record ProcessorsRange(Processors min, @Nullable Processors max) implements Writeable,
    ToXContentObject
    {
        private static final ParseField MIN_FIELD = new ParseField("min", new String[0]);
        private static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
        public static final ConstructingObjectParser<ProcessorsRange, String> PROCESSORS_RANGE_PARSER = new ConstructingObjectParser<ProcessorsRange, String>("processors_range", false, (args, name) -> new ProcessorsRange((Processors)args[0], (Processors)args[1]));

        public ProcessorsRange(double min, Double max) {
            this(Processors.of(min), Processors.of(max));
        }

        public ProcessorsRange {
            if (max != null && min.compareTo(max) > 0) {
                throw new IllegalArgumentException("min processors must be less than or equal to max processors and it was: min: " + String.valueOf(min) + " max: " + String.valueOf(max));
            }
        }

        static ProcessorsRange fromXContent(XContentParser parser) throws IOException {
            return PROCESSORS_RANGE_PARSER.parse(parser, null);
        }

        private static ProcessorsRange readFrom(StreamInput in) throws IOException {
            return new ProcessorsRange(Processors.readFrom(in), in.readOptionalWriteable(Processors::readFrom));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.min.writeTo(out);
            out.writeOptionalWriteable(this.max);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MIN_FIELD.getPreferredName(), this.min);
            if (this.max != null) {
                builder.field(MAX_FIELD.getPreferredName(), this.max);
            }
            builder.endObject();
            return builder;
        }

        static boolean equalsOrCloseTo(ProcessorsRange a, ProcessorsRange b) {
            return a == b || a != null && a.equalsOrCloseTo(b);
        }

        boolean equalsOrCloseTo(ProcessorsRange that) {
            return that != null && (this.equals(that) || Processors.equalsOrCloseTo(this.min, that.min) && Processors.equalsOrCloseTo(this.max, that.max));
        }

        static {
            PROCESSORS_RANGE_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> Processors.fromXContent(p), MIN_FIELD, ObjectParser.ValueType.DOUBLE);
            PROCESSORS_RANGE_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Processors.fromXContent(p), MAX_FIELD, ObjectParser.ValueType.DOUBLE);
        }
    }
}

