/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record IndicesOptions(ConcreteTargetOptions concreteTargetOptions, WildcardOptions wildcardOptions, GatekeeperOptions gatekeeperOptions) implements ToXContentFragment
{
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(IndicesOptions.class);
    private static final String IGNORE_THROTTLED_DEPRECATION_MESSAGE = "[ignore_throttled] parameter is deprecated because frozen indices have been deprecated. Consider cold or frozen tiers in place of frozen indices.";
    private static final String WILDCARD_NONE_DEPRECATION_MESSAGE = "Combining the value 'none' with other options is deprecated because it is order sensitive. Please revise the expression to work without the 'none' option or only use 'none'.";
    public static final IndicesOptions DEFAULT = new IndicesOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS, WildcardOptions.DEFAULT, GatekeeperOptions.DEFAULT);
    public static final IndicesOptions STRICT_EXPAND_OPEN = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(true).ignoreThrottled(false)).build();
    public static final IndicesOptions STRICT_EXPAND_OPEN_FAILURE_NO_SELECTOR = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(false).includeFailureIndices(true).ignoreThrottled(false)).build();
    public static final IndicesOptions LENIENT_EXPAND_OPEN = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(true).ignoreThrottled(false)).build();
    public static final IndicesOptions LENIENT_EXPAND_OPEN_NO_SELECTORS = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(false).ignoreThrottled(false)).build();
    public static final IndicesOptions LENIENT_EXPAND_OPEN_HIDDEN = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(true).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(true).ignoreThrottled(false)).build();
    public static final IndicesOptions LENIENT_EXPAND_OPEN_CLOSED = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(true).ignoreThrottled(false)).build();
    public static final IndicesOptions LENIENT_EXPAND_OPEN_CLOSED_HIDDEN = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(true).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(true).ignoreThrottled(false)).build();
    public static final IndicesOptions LENIENT_EXPAND_OPEN_CLOSED_HIDDEN_NO_SELECTOR = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(true).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(false).ignoreThrottled(false)).build();
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(true).ignoreThrottled(false)).build();
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED_HIDDEN = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(true).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(true).ignoreThrottled(false)).build();
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED_HIDDEN_NO_SELECTORS = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(true).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(false).ignoreThrottled(false)).build();
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED_HIDDEN_FAILURE_NO_SELECTORS = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(true).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(true).allowClosedIndices(true).allowSelectors(false).includeFailureIndices(true).ignoreThrottled(false)).build();
    public static final IndicesOptions STRICT_EXPAND_OPEN_FORBID_CLOSED = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowClosedIndices(false).allowAliasToMultipleIndices(true).allowSelectors(true).ignoreThrottled(false)).build();
    public static final IndicesOptions STRICT_EXPAND_OPEN_HIDDEN_FORBID_CLOSED = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(true).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowClosedIndices(false).allowAliasToMultipleIndices(true).allowSelectors(true).ignoreThrottled(false)).build();
    public static final IndicesOptions STRICT_EXPAND_OPEN_FORBID_CLOSED_IGNORE_THROTTLED = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().ignoreThrottled(true).allowClosedIndices(false).allowSelectors(true).allowAliasToMultipleIndices(true)).build();
    public static final IndicesOptions STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(false).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(false).allowClosedIndices(false).allowSelectors(false).ignoreThrottled(false)).build();
    public static final IndicesOptions STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED_ALLOW_SELECTORS = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(false).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowAliasToMultipleIndices(false).allowClosedIndices(false).allowSelectors(true).ignoreThrottled(false)).build();
    public static final IndicesOptions STRICT_NO_EXPAND_FORBID_CLOSED = IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(WildcardOptions.builder().matchOpen(false).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(GatekeeperOptions.builder().allowClosedIndices(false).allowAliasToMultipleIndices(true).allowSelectors(true).ignoreThrottled(false)).build();
    private static final ParseField EXPAND_WILDCARDS_FIELD = new ParseField("expand_wildcards", new String[0]);
    private static final ParseField IGNORE_UNAVAILABLE_FIELD = new ParseField("ignore_unavailable", new String[0]);
    private static final ParseField IGNORE_THROTTLED_FIELD = new ParseField("ignore_throttled", new String[0]).withAllDeprecated();
    private static final ParseField ALLOW_NO_INDICES_FIELD = new ParseField("allow_no_indices", new String[0]);

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IndicesOptions indicesOptions) {
        return new Builder(indicesOptions);
    }

    public boolean ignoreUnavailable() {
        return this.concreteTargetOptions.allowUnavailableTargets();
    }

    public boolean allowNoIndices() {
        return this.wildcardOptions.allowEmptyExpressions();
    }

    public boolean expandWildcardsOpen() {
        return this.wildcardOptions.matchOpen();
    }

    public boolean expandWildcardsClosed() {
        return this.wildcardOptions.matchClosed();
    }

    public boolean expandWildcardExpressions() {
        return this.expandWildcardsOpen() || this.expandWildcardsClosed();
    }

    public boolean expandWildcardsHidden() {
        return this.wildcardOptions.includeHidden();
    }

    public boolean forbidClosedIndices() {
        return !this.gatekeeperOptions.allowClosedIndices();
    }

    public boolean allowSelectors() {
        return this.gatekeeperOptions.allowSelectors();
    }

    public boolean includeFailureIndices() {
        return this.gatekeeperOptions.includeFailureIndices();
    }

    public boolean allowAliasesToMultipleIndices() {
        return this.gatekeeperOptions().allowAliasToMultipleIndices();
    }

    public boolean ignoreAliases() {
        return !this.wildcardOptions.resolveAliases();
    }

    public boolean ignoreThrottled() {
        return this.gatekeeperOptions().ignoreThrottled();
    }

    public void writeIndicesOptions(StreamOutput out) throws IOException {
        EnumSet<Option> backwardsCompatibleOptions = EnumSet.noneOf(Option.class);
        if (this.allowNoIndices()) {
            backwardsCompatibleOptions.add(Option.ALLOW_EMPTY_WILDCARD_EXPRESSIONS);
        }
        if (this.ignoreAliases()) {
            backwardsCompatibleOptions.add(Option.EXCLUDE_ALIASES);
        }
        if (!this.allowAliasesToMultipleIndices()) {
            backwardsCompatibleOptions.add(Option.ERROR_WHEN_ALIASES_TO_MULTIPLE_INDICES);
        }
        if (this.forbidClosedIndices()) {
            backwardsCompatibleOptions.add(Option.ERROR_WHEN_CLOSED_INDICES);
        }
        if (this.ignoreThrottled()) {
            backwardsCompatibleOptions.add(Option.IGNORE_THROTTLED);
        }
        if (this.ignoreUnavailable()) {
            backwardsCompatibleOptions.add(Option.ALLOW_UNAVAILABLE_CONCRETE_TARGETS);
        }
        if (this.gatekeeperOptions().allowSelectors()) {
            if (out.getTransportVersion().between(TransportVersions.V_8_14_0, TransportVersions.REPLACE_FAILURE_STORE_OPTIONS_WITH_SELECTOR_SYNTAX)) {
                backwardsCompatibleOptions.add(Option.ALLOW_FAILURE_INDICES);
            } else if (out.getTransportVersion().onOrAfter(TransportVersions.REPLACE_FAILURE_STORE_OPTIONS_WITH_SELECTOR_SYNTAX)) {
                backwardsCompatibleOptions.add(Option.ALLOW_SELECTORS);
            }
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.ADD_INCLUDE_FAILURE_INDICES_OPTION) && this.gatekeeperOptions.includeFailureIndices()) {
            backwardsCompatibleOptions.add(Option.INCLUDE_FAILURE_INDICES);
        }
        out.writeEnumSet(backwardsCompatibleOptions);
        EnumSet<WildcardStates> states = EnumSet.noneOf(WildcardStates.class);
        if (this.wildcardOptions.matchOpen()) {
            states.add(WildcardStates.OPEN);
        }
        if (this.wildcardOptions.matchClosed) {
            states.add(WildcardStates.CLOSED);
        }
        if (this.wildcardOptions.includeHidden()) {
            states.add(WildcardStates.HIDDEN);
        }
        out.writeEnumSet(states);
        if (out.getTransportVersion().between(TransportVersions.V_8_14_0, TransportVersions.V_8_16_0)) {
            out.writeBoolean(true);
            out.writeBoolean(false);
        }
        if (out.getTransportVersion().between(TransportVersions.V_8_16_0, TransportVersions.REPLACE_FAILURE_STORE_OPTIONS_WITH_SELECTOR_SYNTAX)) {
            if (out.getTransportVersion().before(TransportVersions.INTRODUCE_ALL_APPLICABLE_SELECTOR)) {
                out.writeVInt(1);
                out.writeVInt(0);
            } else {
                out.writeByte((byte)0);
            }
        }
    }

    public static IndicesOptions readIndicesOptions(StreamInput in) throws IOException {
        EnumSet<Option> options = in.readEnumSet(Option.class);
        WildcardOptions wildcardOptions = WildcardStates.toWildcardOptions(in.readEnumSet(WildcardStates.class), options.contains((Object)Option.ALLOW_EMPTY_WILDCARD_EXPRESSIONS), options.contains((Object)Option.EXCLUDE_ALIASES));
        boolean allowSelectors = true;
        if (in.getTransportVersion().between(TransportVersions.V_8_14_0, TransportVersions.REPLACE_FAILURE_STORE_OPTIONS_WITH_SELECTOR_SYNTAX)) {
            allowSelectors = options.contains((Object)Option.ALLOW_FAILURE_INDICES);
        } else if (in.getTransportVersion().onOrAfter(TransportVersions.REPLACE_FAILURE_STORE_OPTIONS_WITH_SELECTOR_SYNTAX)) {
            allowSelectors = options.contains((Object)Option.ALLOW_SELECTORS);
        }
        boolean includeFailureIndices = false;
        if (in.getTransportVersion().onOrAfter(TransportVersions.ADD_INCLUDE_FAILURE_INDICES_OPTION)) {
            includeFailureIndices = options.contains((Object)Option.INCLUDE_FAILURE_INDICES);
        }
        GatekeeperOptions gatekeeperOptions = GatekeeperOptions.builder().allowClosedIndices(!options.contains((Object)Option.ERROR_WHEN_CLOSED_INDICES)).allowAliasToMultipleIndices(!options.contains((Object)Option.ERROR_WHEN_ALIASES_TO_MULTIPLE_INDICES)).allowSelectors(allowSelectors).includeFailureIndices(includeFailureIndices).ignoreThrottled(options.contains((Object)Option.IGNORE_THROTTLED)).build();
        if (in.getTransportVersion().between(TransportVersions.V_8_14_0, TransportVersions.V_8_16_0)) {
            in.readBoolean();
            in.readBoolean();
        }
        if (in.getTransportVersion().between(TransportVersions.V_8_16_0, TransportVersions.REPLACE_FAILURE_STORE_OPTIONS_WITH_SELECTOR_SYNTAX)) {
            if (in.getTransportVersion().before(TransportVersions.INTRODUCE_ALL_APPLICABLE_SELECTOR)) {
                int size = in.readVInt();
                for (int i = 0; i < size; ++i) {
                    in.readVInt();
                }
            } else {
                in.readByte();
            }
        }
        return new IndicesOptions(options.contains((Object)Option.ALLOW_UNAVAILABLE_CONCRETE_TARGETS) ? ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS : ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS, wildcardOptions, gatekeeperOptions);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, false);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean expandToHiddenIndices) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, expandToHiddenIndices, true, false, false, false);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, IndicesOptions defaultOptions) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, defaultOptions.expandWildcardsHidden(), defaultOptions.allowAliasesToMultipleIndices(), defaultOptions.forbidClosedIndices(), defaultOptions.ignoreAliases(), defaultOptions.ignoreThrottled());
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices, boolean ignoreAliases, boolean ignoreThrottled) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, false, allowAliasesToMultipleIndices, forbidClosedIndices, ignoreAliases, ignoreThrottled);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean expandToHiddenIndices, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices, boolean ignoreAliases, boolean ignoreThrottled) {
        WildcardOptions wildcards = WildcardOptions.builder().matchOpen(expandToOpenIndices).matchClosed(expandToClosedIndices).includeHidden(expandToHiddenIndices).resolveAliases(!ignoreAliases).allowEmptyExpressions(allowNoIndices).build();
        GatekeeperOptions gatekeeperOptions = GatekeeperOptions.builder().allowAliasToMultipleIndices(allowAliasesToMultipleIndices).allowClosedIndices(!forbidClosedIndices).ignoreThrottled(ignoreThrottled).build();
        return new IndicesOptions(ignoreUnavailable ? ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS : ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS, wildcards, gatekeeperOptions);
    }

    public static IndicesOptions fromRequest(RestRequest request, IndicesOptions defaultSettings) {
        if (request.hasParam("ignore_throttled")) {
            DEPRECATION_LOGGER.warn(DeprecationCategory.API, "ignore_throttled_param", IGNORE_THROTTLED_DEPRECATION_MESSAGE, new Object[0]);
        }
        return IndicesOptions.fromParameters(request.param("expand_wildcards"), request.param("ignore_unavailable"), request.param("allow_no_indices"), request.param("ignore_throttled"), defaultSettings);
    }

    public static IndicesOptions fromMap(Map<String, Object> map, IndicesOptions defaultSettings) {
        return IndicesOptions.fromParameters(map.containsKey("expand_wildcards") ? map.get("expand_wildcards") : map.get("expandWildcards"), map.containsKey("ignore_unavailable") ? map.get("ignore_unavailable") : map.get("ignoreUnavailable"), map.containsKey("allow_no_indices") ? map.get("allow_no_indices") : map.get("allowNoIndices"), map.containsKey("ignore_throttled") ? map.get("ignore_throttled") : map.get("ignoreThrottled"), defaultSettings);
    }

    public static boolean isIndicesOptions(String name) {
        return "expand_wildcards".equals(name) || "expandWildcards".equals(name) || "ignore_unavailable".equals(name) || "ignoreUnavailable".equals(name) || "ignore_throttled".equals(name) || "ignoreThrottled".equals(name) || "allow_no_indices".equals(name) || "allowNoIndices".equals(name);
    }

    public static IndicesOptions fromParameters(Object wildcardsString, Object ignoreUnavailableString, Object allowNoIndicesString, Object ignoreThrottled, IndicesOptions defaultSettings) {
        return IndicesOptions.fromParameters(wildcardsString, ignoreUnavailableString, allowNoIndicesString, ignoreThrottled, null, defaultSettings);
    }

    public static IndicesOptions fromParameters(Object wildcardsString, Object ignoreUnavailableString, Object allowNoIndicesString, Object ignoreThrottled, Object failureStoreString, IndicesOptions defaultSettings) {
        if (wildcardsString == null && ignoreUnavailableString == null && allowNoIndicesString == null && ignoreThrottled == null && failureStoreString == null) {
            return defaultSettings;
        }
        WildcardOptions wildcards = WildcardOptions.parseParameters(wildcardsString, allowNoIndicesString, defaultSettings.wildcardOptions);
        GatekeeperOptions gatekeeperOptions = GatekeeperOptions.parseParameter(ignoreThrottled, defaultSettings.gatekeeperOptions);
        return IndicesOptions.builder().concreteTargetOptions(ConcreteTargetOptions.fromParameter(ignoreUnavailableString, defaultSettings.concreteTargetOptions)).wildcardOptions(wildcards).gatekeeperOptions(gatekeeperOptions).build();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.concreteTargetOptions.toXContent(builder, params);
        this.wildcardOptions.toXContent(builder, params);
        this.gatekeeperOptions.toXContent(builder, params);
        return builder;
    }

    public static IndicesOptions fromXContent(XContentParser parser) throws IOException {
        return IndicesOptions.fromXContent(parser, null);
    }

    public static IndicesOptions fromXContent(XContentParser parser, @Nullable IndicesOptions defaults) throws IOException {
        boolean parsedWildcardStates = false;
        WildcardOptions.Builder wildcards = defaults == null ? null : WildcardOptions.builder(defaults.wildcardOptions());
        GatekeeperOptions.Builder generalOptions = GatekeeperOptions.builder().ignoreThrottled(defaults != null && defaults.gatekeeperOptions().ignoreThrottled());
        Boolean allowNoIndices = defaults == null ? null : Boolean.valueOf(defaults.allowNoIndices());
        Boolean ignoreUnavailable = defaults == null ? null : Boolean.valueOf(defaults.ignoreUnavailable());
        XContentParser.Token token = parser.currentToken() == XContentParser.Token.START_OBJECT ? parser.currentToken() : parser.nextToken();
        String currentFieldName = null;
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("expected START_OBJECT as the token but was " + String.valueOf((Object)token), new Object[0]);
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (EXPAND_WILDCARDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (!parsedWildcardStates) {
                        parsedWildcardStates = true;
                        wildcards = WildcardOptions.builder();
                        ArrayList<String> values = new ArrayList<String>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token.isValue()) {
                                values.add(parser.text());
                                continue;
                            }
                            throw new ElasticsearchParseException("expected values within array for " + EXPAND_WILDCARDS_FIELD.getPreferredName(), new Object[0]);
                        }
                        wildcards.expandStates(values.toArray(new String[0]));
                        continue;
                    }
                    throw new ElasticsearchParseException("already parsed expand_wildcards", new Object[0]);
                }
                throw new ElasticsearchParseException(EXPAND_WILDCARDS_FIELD.getPreferredName() + " is the only field that is an array in IndicesOptions", new Object[0]);
            }
            if (token.isValue()) {
                if (EXPAND_WILDCARDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (!parsedWildcardStates) {
                        parsedWildcardStates = true;
                        wildcards = WildcardOptions.builder();
                        wildcards.expandStates(new String[]{parser.text()});
                        continue;
                    }
                    throw new ElasticsearchParseException("already parsed expand_wildcards", new Object[0]);
                }
                if (IGNORE_UNAVAILABLE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ignoreUnavailable = parser.booleanValue();
                    continue;
                }
                if (ALLOW_NO_INDICES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    allowNoIndices = parser.booleanValue();
                    continue;
                }
                if (IGNORE_THROTTLED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    generalOptions.ignoreThrottled(parser.booleanValue());
                    continue;
                }
                throw new ElasticsearchParseException("could not read indices options. Unexpected index option [" + currentFieldName + "]", new Object[0]);
            }
            throw new ElasticsearchParseException("could not read indices options. Unexpected object field [" + currentFieldName + "]", new Object[0]);
        }
        if (wildcards == null) {
            throw new ElasticsearchParseException("indices options xcontent did not contain " + EXPAND_WILDCARDS_FIELD.getPreferredName(), new Object[0]);
        }
        if (allowNoIndices == null) {
            throw new ElasticsearchParseException("indices options xcontent did not contain " + ALLOW_NO_INDICES_FIELD.getPreferredName(), new Object[0]);
        }
        wildcards.allowEmptyExpressions(allowNoIndices);
        if (ignoreUnavailable == null) {
            throw new ElasticsearchParseException("indices options xcontent did not contain " + IGNORE_UNAVAILABLE_FIELD.getPreferredName(), new Object[0]);
        }
        return IndicesOptions.builder().concreteTargetOptions(new ConcreteTargetOptions(ignoreUnavailable)).wildcardOptions(wildcards).gatekeeperOptions(generalOptions).build();
    }

    public static IndicesOptions strictExpandOpen() {
        return STRICT_EXPAND_OPEN;
    }

    public static IndicesOptions strictExpandOpenFailureNoSelectors() {
        return STRICT_EXPAND_OPEN_FAILURE_NO_SELECTOR;
    }

    public static IndicesOptions strictExpandOpenAndForbidClosed() {
        return STRICT_EXPAND_OPEN_FORBID_CLOSED;
    }

    public static IndicesOptions strictExpandOpenAndForbidClosedIgnoreThrottled() {
        return STRICT_EXPAND_OPEN_FORBID_CLOSED_IGNORE_THROTTLED;
    }

    public static IndicesOptions strictExpand() {
        return STRICT_EXPAND_OPEN_CLOSED;
    }

    public static IndicesOptions strictExpandHidden() {
        return STRICT_EXPAND_OPEN_CLOSED_HIDDEN;
    }

    public static IndicesOptions strictExpandHiddenNoSelectors() {
        return STRICT_EXPAND_OPEN_CLOSED_HIDDEN_NO_SELECTORS;
    }

    public static IndicesOptions strictExpandHiddenFailureNoSelectors() {
        return STRICT_EXPAND_OPEN_CLOSED_HIDDEN_FAILURE_NO_SELECTORS;
    }

    public static IndicesOptions strictNoExpandForbidClosed() {
        return STRICT_NO_EXPAND_FORBID_CLOSED;
    }

    public static IndicesOptions strictSingleIndexNoExpandForbidClosed() {
        return STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED;
    }

    public static IndicesOptions strictSingleIndexNoExpandForbidClosedAllowSelectors() {
        return STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED_ALLOW_SELECTORS;
    }

    public static IndicesOptions lenientExpandOpen() {
        return LENIENT_EXPAND_OPEN;
    }

    public static IndicesOptions lenientExpandOpenNoSelectors() {
        return LENIENT_EXPAND_OPEN_NO_SELECTORS;
    }

    public static IndicesOptions lenientExpandOpenHidden() {
        return LENIENT_EXPAND_OPEN_HIDDEN;
    }

    public static IndicesOptions lenientExpand() {
        return LENIENT_EXPAND_OPEN_CLOSED;
    }

    public static IndicesOptions lenientExpandHidden() {
        return LENIENT_EXPAND_OPEN_CLOSED_HIDDEN;
    }

    @Override
    public String toString() {
        return "IndicesOptions[ignore_unavailable=" + this.ignoreUnavailable() + ", allow_no_indices=" + this.allowNoIndices() + ", expand_wildcards_open=" + this.expandWildcardsOpen() + ", expand_wildcards_closed=" + this.expandWildcardsClosed() + ", expand_wildcards_hidden=" + this.expandWildcardsHidden() + ", allow_aliases_to_multiple_indices=" + this.allowAliasesToMultipleIndices() + ", forbid_closed_indices=" + this.forbidClosedIndices() + ", ignore_aliases=" + this.ignoreAliases() + ", ignore_throttled=" + this.ignoreThrottled() + ", allow_selectors=" + this.allowSelectors() + ", include_failure_indices=" + this.includeFailureIndices() + "]";
    }

    public record ConcreteTargetOptions(boolean allowUnavailableTargets) implements ToXContentFragment
    {
        public static final String IGNORE_UNAVAILABLE = "ignore_unavailable";
        public static final ConcreteTargetOptions ALLOW_UNAVAILABLE_TARGETS = new ConcreteTargetOptions(true);
        public static final ConcreteTargetOptions ERROR_WHEN_UNAVAILABLE_TARGETS = new ConcreteTargetOptions(false);

        public static ConcreteTargetOptions fromParameter(Object ignoreUnavailableString, ConcreteTargetOptions defaultOption) {
            if (ignoreUnavailableString == null && defaultOption != null) {
                return defaultOption;
            }
            return XContentMapValues.nodeBooleanValue(ignoreUnavailableString, IGNORE_UNAVAILABLE) ? ALLOW_UNAVAILABLE_TARGETS : ERROR_WHEN_UNAVAILABLE_TARGETS;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(IGNORE_UNAVAILABLE, this.allowUnavailableTargets);
        }
    }

    public record WildcardOptions(boolean matchOpen, boolean matchClosed, boolean includeHidden, boolean resolveAliases, boolean allowEmptyExpressions) implements ToXContentFragment
    {
        public static final String EXPAND_WILDCARDS = "expand_wildcards";
        public static final String ALLOW_NO_INDICES = "allow_no_indices";
        public static final WildcardOptions DEFAULT = new WildcardOptions(true, false, false, true, true);

        public static WildcardOptions parseParameters(Object expandWildcards, Object allowNoIndices, WildcardOptions defaultOptions) {
            Builder builder;
            if (expandWildcards == null && allowNoIndices == null) {
                return defaultOptions;
            }
            Builder builder2 = builder = defaultOptions == null ? new Builder() : new Builder(defaultOptions);
            if (expandWildcards != null) {
                builder.matchNone();
                builder.expandStates(XContentMapValues.nodeStringArrayValue(expandWildcards));
            }
            if (allowNoIndices != null) {
                builder.allowEmptyExpressions(XContentMapValues.nodeBooleanValue(allowNoIndices, ALLOW_NO_INDICES));
            }
            return builder.build();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.toXContent(builder, false);
        }

        public XContentBuilder toXContent(XContentBuilder builder, boolean wildcardStatesAsUserInput) throws IOException {
            EnumSet<WildcardStates> legacyStates = EnumSet.noneOf(WildcardStates.class);
            if (this.matchOpen()) {
                legacyStates.add(WildcardStates.OPEN);
            }
            if (this.matchClosed()) {
                legacyStates.add(WildcardStates.CLOSED);
            }
            if (this.includeHidden()) {
                legacyStates.add(WildcardStates.HIDDEN);
            }
            if (wildcardStatesAsUserInput) {
                if (legacyStates.isEmpty()) {
                    builder.field(EXPAND_WILDCARDS, "none");
                } else if (legacyStates.equals(EnumSet.allOf(WildcardStates.class))) {
                    builder.field(EXPAND_WILDCARDS, "all");
                } else {
                    builder.field(EXPAND_WILDCARDS, legacyStates.stream().map(WildcardStates::displayName).collect(Collectors.joining(",")));
                }
            } else {
                builder.startArray(EXPAND_WILDCARDS);
                for (WildcardStates state : legacyStates) {
                    builder.value(state.displayName());
                }
                builder.endArray();
            }
            builder.field(ALLOW_NO_INDICES, this.allowEmptyExpressions());
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(WildcardOptions wildcardOptions) {
            return new Builder(wildcardOptions);
        }

        public static class Builder {
            private boolean matchOpen;
            private boolean matchClosed;
            private boolean includeHidden;
            private boolean resolveAliases;
            private boolean allowEmptyExpressions;

            Builder() {
                this(DEFAULT);
            }

            Builder(WildcardOptions options) {
                this.matchOpen = options.matchOpen;
                this.matchClosed = options.matchClosed;
                this.includeHidden = options.includeHidden;
                this.resolveAliases = options.resolveAliases;
                this.allowEmptyExpressions = options.allowEmptyExpressions;
            }

            public Builder matchOpen(boolean matchOpen) {
                this.matchOpen = matchOpen;
                return this;
            }

            public Builder matchClosed(boolean matchClosed) {
                this.matchClosed = matchClosed;
                return this;
            }

            public Builder includeHidden(boolean includeHidden) {
                this.includeHidden = includeHidden;
                return this;
            }

            public Builder resolveAliases(boolean resolveAliases) {
                this.resolveAliases = resolveAliases;
                return this;
            }

            public Builder allowEmptyExpressions(boolean allowEmptyExpressions) {
                this.allowEmptyExpressions = allowEmptyExpressions;
                return this;
            }

            public Builder matchNone() {
                this.matchOpen = false;
                this.matchClosed = false;
                this.includeHidden = false;
                return this;
            }

            public Builder all() {
                this.matchOpen = true;
                this.matchClosed = true;
                this.includeHidden = true;
                return this;
            }

            public Builder expandStates(String[] expandStates) {
                this.matchNone();
                String[] stringArray = expandStates;
                int n = stringArray.length;
                block14: for (int i = 0; i < n; ++i) {
                    String expandState;
                    switch (expandState = stringArray[i]) {
                        case "open": {
                            this.matchOpen(true);
                            continue block14;
                        }
                        case "closed": {
                            this.matchClosed(true);
                            continue block14;
                        }
                        case "hidden": {
                            this.includeHidden(true);
                            continue block14;
                        }
                        case "all": {
                            this.all();
                            continue block14;
                        }
                        case "none": {
                            this.matchNone();
                            if (expandStates.length <= 1) continue block14;
                            DEPRECATION_LOGGER.warn(DeprecationCategory.API, WildcardOptions.EXPAND_WILDCARDS, IndicesOptions.WILDCARD_NONE_DEPRECATION_MESSAGE, new Object[0]);
                            continue block14;
                        }
                        default: {
                            throw new IllegalArgumentException("No valid expand wildcard value [" + expandState + "]");
                        }
                    }
                }
                return this;
            }

            public WildcardOptions build() {
                return new WildcardOptions(this.matchOpen, this.matchClosed, this.includeHidden, this.resolveAliases, this.allowEmptyExpressions);
            }
        }
    }

    public record GatekeeperOptions(boolean allowAliasToMultipleIndices, boolean allowClosedIndices, boolean allowSelectors, boolean includeFailureIndices, @Deprecated boolean ignoreThrottled) implements ToXContentFragment
    {
        public static final String IGNORE_THROTTLED = "ignore_throttled";
        public static final GatekeeperOptions DEFAULT = new GatekeeperOptions(true, true, true, false, false);

        public static GatekeeperOptions parseParameter(Object ignoreThrottled, GatekeeperOptions defaultOptions) {
            if (ignoreThrottled == null && defaultOptions != null) {
                return defaultOptions;
            }
            return (defaultOptions == null ? new Builder() : new Builder(defaultOptions)).ignoreThrottled(XContentMapValues.nodeBooleanValue(ignoreThrottled, IGNORE_THROTTLED)).build();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(IGNORE_THROTTLED, this.ignoreThrottled());
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(GatekeeperOptions gatekeeperOptions) {
            return new Builder(gatekeeperOptions);
        }

        public static class Builder {
            private boolean allowAliasToMultipleIndices;
            private boolean allowClosedIndices;
            private boolean allowSelectors;
            private boolean includeFailureIndices;
            private boolean ignoreThrottled;

            public Builder() {
                this(DEFAULT);
            }

            Builder(GatekeeperOptions options) {
                this.allowAliasToMultipleIndices = options.allowAliasToMultipleIndices;
                this.allowClosedIndices = options.allowClosedIndices;
                this.allowSelectors = options.allowSelectors;
                this.includeFailureIndices = options.includeFailureIndices;
                this.ignoreThrottled = options.ignoreThrottled;
            }

            public Builder allowAliasToMultipleIndices(boolean allowAliasToMultipleIndices) {
                this.allowAliasToMultipleIndices = allowAliasToMultipleIndices;
                return this;
            }

            public Builder allowClosedIndices(boolean allowClosedIndices) {
                this.allowClosedIndices = allowClosedIndices;
                return this;
            }

            public Builder allowSelectors(boolean allowSelectors) {
                this.allowSelectors = allowSelectors;
                return this;
            }

            public Builder includeFailureIndices(boolean includeFailureIndices) {
                this.includeFailureIndices = includeFailureIndices;
                return this;
            }

            public Builder ignoreThrottled(boolean ignoreThrottled) {
                this.ignoreThrottled = ignoreThrottled;
                return this;
            }

            public GatekeeperOptions build() {
                return new GatekeeperOptions(this.allowAliasToMultipleIndices, this.allowClosedIndices, this.allowSelectors, this.includeFailureIndices, this.ignoreThrottled);
            }
        }
    }

    public static class Builder {
        private ConcreteTargetOptions concreteTargetOptions;
        private WildcardOptions wildcardOptions;
        private GatekeeperOptions gatekeeperOptions;

        Builder() {
            this(DEFAULT);
        }

        Builder(IndicesOptions indicesOptions) {
            this.concreteTargetOptions = indicesOptions.concreteTargetOptions;
            this.wildcardOptions = indicesOptions.wildcardOptions;
            this.gatekeeperOptions = indicesOptions.gatekeeperOptions;
        }

        public Builder concreteTargetOptions(ConcreteTargetOptions concreteTargetOptions) {
            this.concreteTargetOptions = concreteTargetOptions;
            return this;
        }

        public Builder wildcardOptions(WildcardOptions wildcardOptions) {
            this.wildcardOptions = wildcardOptions;
            return this;
        }

        public Builder wildcardOptions(WildcardOptions.Builder wildcardOptions) {
            this.wildcardOptions = wildcardOptions.build();
            return this;
        }

        public Builder gatekeeperOptions(GatekeeperOptions gatekeeperOptions) {
            this.gatekeeperOptions = gatekeeperOptions;
            return this;
        }

        public Builder gatekeeperOptions(GatekeeperOptions.Builder generalOptions) {
            this.gatekeeperOptions = generalOptions.build();
            return this;
        }

        public IndicesOptions build() {
            return new IndicesOptions(this.concreteTargetOptions, this.wildcardOptions, this.gatekeeperOptions);
        }
    }

    private static enum Option {
        ALLOW_UNAVAILABLE_CONCRETE_TARGETS,
        EXCLUDE_ALIASES,
        ALLOW_EMPTY_WILDCARD_EXPRESSIONS,
        ERROR_WHEN_ALIASES_TO_MULTIPLE_INDICES,
        ERROR_WHEN_CLOSED_INDICES,
        IGNORE_THROTTLED,
        ALLOW_FAILURE_INDICES,
        ALLOW_SELECTORS,
        INCLUDE_FAILURE_INDICES;

    }

    private static enum WildcardStates {
        OPEN,
        CLOSED,
        HIDDEN;


        static WildcardOptions toWildcardOptions(EnumSet<WildcardStates> states, boolean allowNoIndices, boolean ignoreAlias) {
            return WildcardOptions.builder().matchOpen(states.contains((Object)OPEN)).matchClosed(states.contains((Object)CLOSED)).includeHidden(states.contains((Object)HIDDEN)).allowEmptyExpressions(allowNoIndices).resolveAliases(!ignoreAlias).build();
        }

        String displayName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

