/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.filters.elasticintegration.PipelineConfigurationFactory;
import co.elastic.logstash.filters.elasticintegration.PipelineConfigurationResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.AbstractSimpleResolver;
import java.util.Optional;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.ingest.PipelineConfiguration;

public class ElasticsearchPipelineConfigurationResolver
extends AbstractSimpleResolver<String, PipelineConfiguration>
implements PipelineConfigurationResolver {
    private final RestClient elasticsearchRestClient;
    private final PipelineConfigurationFactory pipelineConfigurationFactory;
    private static final Logger LOGGER = LogManager.getLogger(ElasticsearchPipelineConfigurationResolver.class);

    public ElasticsearchPipelineConfigurationResolver(RestClient elasticsearchRestClient) {
        this.elasticsearchRestClient = elasticsearchRestClient;
        this.pipelineConfigurationFactory = PipelineConfigurationFactory.getInstance();
    }

    @Override
    public Optional<PipelineConfiguration> resolveSafely(String pipelineName) throws Exception {
        try {
            Request request = new Request("GET", URLEncodedUtils.formatSegments("_ingest", "pipeline", pipelineName));
            Response response = this.elasticsearchRestClient.performRequest(request);
            String jsonEncodedPayload = EntityUtils.toString(response.getEntity());
            PipelineConfiguration pipelineConfiguration = this.pipelineConfigurationFactory.parseNamedObject(jsonEncodedPayload);
            return Optional.of(pipelineConfiguration);
        }
        catch (ResponseException re) {
            if (re.getResponse().getStatusLine().getStatusCode() == 404) {
                LOGGER.debug(String.format("pipeline not found: `%s`", pipelineName), (Throwable)re);
            }
            LOGGER.error(String.format("failed to fetch pipeline: `%s`", pipelineName), (Throwable)re);
            throw re;
        }
        catch (Exception ex) {
            LOGGER.error(String.format("failed to fetch pipeline: `%s`", pipelineName), (Throwable)ex);
            throw ex;
        }
        return Optional.empty();
    }
}

