/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class User
implements JsonpSerializable {
    @Nullable
    private final String email;
    @Nullable
    private final String fullName;
    private final Map<String, JsonData> metadata;
    private final List<String> roles;
    private final String username;
    private final boolean enabled;
    @Nullable
    private final String profileUid;
    public static final JsonpDeserializer<User> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, User::setupUserDeserializer);

    protected User(AbstractBuilder<?> builder) {
        this.email = ((AbstractBuilder)builder).email;
        this.fullName = ((AbstractBuilder)builder).fullName;
        this.metadata = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).metadata, (Object)this, "metadata");
        this.roles = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).roles, (Object)this, "roles");
        this.username = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).username, this, "username");
        this.enabled = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).enabled, (Object)this, "enabled", false);
        this.profileUid = ((AbstractBuilder)builder).profileUid;
    }

    public static User userOf(Function<Builder, ObjectBuilder<User>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String email() {
        return this.email;
    }

    @Nullable
    public final String fullName() {
        return this.fullName;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final List<String> roles() {
        return this.roles;
    }

    public final String username() {
        return this.username;
    }

    public final boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final String profileUid() {
        return this.profileUid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.email != null) {
            generator.writeKey("email");
            generator.write(this.email);
        }
        if (this.fullName != null) {
            generator.writeKey("full_name");
            generator.write(this.fullName);
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("username");
        generator.write(this.username);
        generator.writeKey("enabled");
        generator.write(this.enabled);
        if (this.profileUid != null) {
            generator.writeKey("profile_uid");
            generator.write(this.profileUid);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupUserDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::email, JsonpDeserializer.stringDeserializer(), "email");
        op.add(AbstractBuilder::fullName, JsonpDeserializer.stringDeserializer(), "full_name");
        op.add(AbstractBuilder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(AbstractBuilder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(AbstractBuilder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(AbstractBuilder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(AbstractBuilder::profileUid, JsonpDeserializer.stringDeserializer(), "profile_uid");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String email;
        @Nullable
        private String fullName;
        private Map<String, JsonData> metadata;
        private List<String> roles;
        private String username;
        private Boolean enabled;
        @Nullable
        private String profileUid;

        public final BuilderT email(@Nullable String value) {
            this.email = value;
            return (BuilderT)this.self();
        }

        public final BuilderT fullName(@Nullable String value) {
            this.fullName = value;
            return (BuilderT)this.self();
        }

        public final BuilderT metadata(Map<String, JsonData> map) {
            this.metadata = AbstractBuilder._mapPutAll(this.metadata, map);
            return (BuilderT)this.self();
        }

        public final BuilderT metadata(String key, JsonData value) {
            this.metadata = AbstractBuilder._mapPut(this.metadata, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT roles(List<String> list) {
            this.roles = AbstractBuilder._listAddAll(this.roles, list);
            return (BuilderT)this.self();
        }

        public final BuilderT roles(String value, String ... values) {
            this.roles = AbstractBuilder._listAdd(this.roles, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT username(String value) {
            this.username = value;
            return (BuilderT)this.self();
        }

        public final BuilderT enabled(boolean value) {
            this.enabled = value;
            return (BuilderT)this.self();
        }

        public final BuilderT profileUid(@Nullable String value) {
            this.profileUid = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<User> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public User build() {
            this._checkSingleUse();
            return new User(this);
        }
    }
}

