/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.HighlightBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HighlightField
extends HighlightBase {
    @Nullable
    private final Integer fragmentOffset;
    private final List<String> matchedFields;
    public static final JsonpDeserializer<HighlightField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HighlightField::setupHighlightFieldDeserializer);

    private HighlightField(Builder builder) {
        super(builder);
        this.fragmentOffset = builder.fragmentOffset;
        this.matchedFields = ApiTypeHelper.unmodifiable(builder.matchedFields);
    }

    public static HighlightField of(Function<Builder, ObjectBuilder<HighlightField>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer fragmentOffset() {
        return this.fragmentOffset;
    }

    public final List<String> matchedFields() {
        return this.matchedFields;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.fragmentOffset != null) {
            generator.writeKey("fragment_offset");
            generator.write(this.fragmentOffset);
        }
        if (ApiTypeHelper.isDefined(this.matchedFields)) {
            generator.writeKey("matched_fields");
            generator.writeStartArray();
            for (String item0 : this.matchedFields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupHighlightFieldDeserializer(ObjectDeserializer<Builder> op) {
        HighlightBase.setupHighlightBaseDeserializer(op);
        op.add(Builder::fragmentOffset, JsonpDeserializer.integerDeserializer(), "fragment_offset");
        op.add(Builder::matchedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "matched_fields");
    }

    public static class Builder
    extends HighlightBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HighlightField> {
        @Nullable
        private Integer fragmentOffset;
        @Nullable
        private List<String> matchedFields;

        public final Builder fragmentOffset(@Nullable Integer value) {
            this.fragmentOffset = value;
            return this;
        }

        public final Builder matchedFields(List<String> list) {
            this.matchedFields = Builder._listAddAll(this.matchedFields, list);
            return this;
        }

        public final Builder matchedFields(String value, String ... values) {
            this.matchedFields = Builder._listAdd(this.matchedFields, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HighlightField build() {
            this._checkSingleUse();
            return new HighlightField(this);
        }
    }
}

