/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.instrument.metrics.BaseFlowMetric;
import org.logstash.instrument.metrics.FlowCapture;
import org.logstash.instrument.metrics.FlowMetricRetentionPolicy;
import org.logstash.instrument.metrics.Metric;
import org.logstash.util.SetOnceReference;

public class ExtendedFlowMetric
extends BaseFlowMetric {
    static final Logger LOGGER = LogManager.getLogger(ExtendedFlowMetric.class);
    private final Collection<? extends FlowMetricRetentionPolicy> retentionPolicies;
    private final SetOnceReference<List<RetentionWindow>> retentionWindows = SetOnceReference.unset();

    public ExtendedFlowMetric(String name, Metric<? extends Number> numeratorMetric, Metric<? extends Number> denominatorMetric) {
        this(System::nanoTime, name, numeratorMetric, denominatorMetric);
    }

    ExtendedFlowMetric(LongSupplier nanoTimeSupplier, String name, Metric<? extends Number> numeratorMetric, Metric<? extends Number> denominatorMetric, Collection<? extends FlowMetricRetentionPolicy> retentionPolicies) {
        super(nanoTimeSupplier, name, numeratorMetric, denominatorMetric);
        this.retentionPolicies = List.copyOf(retentionPolicies);
        this.lifetimeBaseline.asOptional().ifPresent(this::appendCapture);
    }

    public ExtendedFlowMetric(LongSupplier nanoTimeSupplier, String name, Metric<? extends Number> numeratorMetric, Metric<? extends Number> denominatorMetric) {
        this(nanoTimeSupplier, name, numeratorMetric, denominatorMetric, EnumSet.allOf(FlowMetricRetentionPolicy.BuiltInRetentionPolicy.class));
    }

    @Override
    public void capture() {
        this.doCapture().ifPresent(this::appendCapture);
    }

    @Override
    public Map<String, Double> getValue() {
        if (!this.lifetimeBaseline.isSet()) {
            return Map.of();
        }
        if (!this.retentionWindows.isSet()) {
            return Map.of();
        }
        Optional<FlowCapture> possibleCapture = this.doCapture();
        if (possibleCapture.isEmpty()) {
            return Map.of();
        }
        FlowCapture currentCapture = possibleCapture.get();
        LinkedHashMap<String, Double> rates = new LinkedHashMap<String, Double>();
        this.retentionWindows.get().forEach(window -> window.baseline(currentCapture.nanoTime()).or(() -> this.windowDefaultBaseline((RetentionWindow)window)).map(baseline -> ExtendedFlowMetric.calculateRate(currentCapture, baseline)).orElseGet(OptionalDouble::empty).ifPresent(rate -> rates.put(window.policy.policyName(), rate)));
        this.injectLifetime(currentCapture, rates);
        return Collections.unmodifiableMap(rates);
    }

    private void appendCapture(FlowCapture capture) {
        this.retentionWindows.ifSetOrElseSupply(existing -> ExtendedFlowMetric.injectIntoRetentionWindows(existing, capture), () -> ExtendedFlowMetric.initRetentionWindows(this.retentionPolicies, capture));
    }

    private static List<RetentionWindow> initRetentionWindows(Collection<? extends FlowMetricRetentionPolicy> retentionPolicies, FlowCapture capture) {
        return retentionPolicies.stream().map(p -> new RetentionWindow((FlowMetricRetentionPolicy)p, capture)).collect(Collectors.toUnmodifiableList());
    }

    private static void injectIntoRetentionWindows(List<RetentionWindow> retentionWindows, FlowCapture capture) {
        retentionWindows.forEach(rw -> rw.append(capture));
    }

    private static FlowCapture selectNewerCapture(FlowCapture existing, FlowCapture proposed) {
        if (existing == null) {
            return proposed;
        }
        if (proposed == null) {
            return existing;
        }
        return existing.nanoTime() > proposed.nanoTime() ? existing : proposed;
    }

    private Optional<FlowCapture> windowDefaultBaseline(RetentionWindow window) {
        if (window.policy.reportBeforeSatisfied()) {
            return this.lifetimeBaseline.asOptional();
        }
        return Optional.empty();
    }

    int estimateCapturesRetained() {
        return this.retentionWindows.orElse(Collections.emptyList()).stream().map(rec$ -> ((RetentionWindow)rec$).estimateSize()).mapToInt(Integer::intValue).sum();
    }

    Duration estimateExcessRetained(ToLongFunction<FlowMetricRetentionPolicy> retentionWindowFunction) {
        long currentNanoTime = this.nanoTimeSupplier.getAsLong();
        long cumulativeExcessRetained = this.retentionWindows.orElse(Collections.emptyList()).stream().map(s -> s.excessRetained(currentNanoTime, retentionWindowFunction)).mapToLong(Long::longValue).sum();
        return Duration.ofNanos(cumulativeExcessRetained);
    }

    private static class RetentionWindow {
        private final AtomicReference<FlowCapture> stagedCapture = new AtomicReference();
        private final AtomicReference<Node> tail;
        private final AtomicReference<Node> head;
        private final FlowMetricRetentionPolicy policy;

        RetentionWindow(FlowMetricRetentionPolicy policy, FlowCapture zeroCapture) {
            this.policy = policy;
            Node zeroNode = new Node(zeroCapture);
            this.head = new AtomicReference<Node>(zeroNode);
            this.tail = new AtomicReference<Node>(zeroNode);
        }

        private void append(FlowCapture newestCapture) {
            Node proposedNode;
            Node casTail = this.tail.getAcquire();
            long newestCaptureNanoTime = newestCapture.nanoTime();
            FlowCapture previouslyStaged = this.stagedCapture.getAndAccumulate(newestCapture, (x$0, x$1) -> ExtendedFlowMetric.selectNewerCapture(x$0, x$1));
            if (previouslyStaged != null && Math.subtractExact(newestCaptureNanoTime, casTail.captureNanoTime()) > this.policy.resolutionNanos() && this.tail.compareAndSet(casTail, proposedNode = new Node(previouslyStaged))) {
                casTail.setNext(proposedNode);
                Node currentHead = this.head.getPlain();
                long headAgeNanos = Math.subtractExact(newestCaptureNanoTime, currentHead.captureNanoTime());
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{} post-append result (captures: `{}` span: `{}` }", (Object)this, (Object)RetentionWindow.estimateSize(currentHead), (Object)Duration.ofNanos(headAgeNanos));
                }
                if (headAgeNanos > this.policy.forceCompactionNanos()) {
                    Node compactHead = this.compactHead(Math.subtractExact(newestCaptureNanoTime, this.policy.retentionNanos()));
                    if (LOGGER.isDebugEnabled()) {
                        long compactHeadAgeNanos = Math.subtractExact(newestCaptureNanoTime, compactHead.captureNanoTime());
                        LOGGER.debug("{} forced-compaction result (captures: `{}` span: `{}`)", (Object)this, (Object)RetentionWindow.estimateSize(compactHead), (Object)Duration.ofNanos(compactHeadAgeNanos));
                    }
                }
            }
        }

        public String toString() {
            return "RetentionWindow{policy=" + this.policy.policyName() + " id=" + System.identityHashCode(this) + "}";
        }

        public Optional<FlowCapture> baseline(long nanoTime) {
            long barrier = Math.subtractExact(nanoTime, this.policy.retentionNanos());
            Node head = this.compactHead(barrier);
            if (head.captureNanoTime() <= barrier) {
                return Optional.of(head.capture);
            }
            return Optional.empty();
        }

        private static int estimateSize(Node headNode) {
            int i = 1;
            for (Node current = headNode; current != null; current = current.getNextPlain()) {
                ++i;
            }
            return i;
        }

        private int estimateSize() {
            return RetentionWindow.estimateSize(this.head.getPlain());
        }

        private Node compactHead(long barrier) {
            return this.head.updateAndGet(existingHead -> {
                Node proposedHead = existingHead.seekWithoutCrossing(barrier);
                return Objects.requireNonNullElse(proposedHead, existingHead);
            });
        }

        private long excessRetained(long currentNanoTime, ToLongFunction<FlowMetricRetentionPolicy> retentionWindowFunction) {
            long barrier = Math.subtractExact(currentNanoTime, retentionWindowFunction.applyAsLong(this.policy));
            return Math.max(0L, Math.subtractExact(barrier, this.head.getPlain().captureNanoTime()));
        }

        private static class Node {
            private static final VarHandle NEXT;
            private final FlowCapture capture;
            private volatile Node next;

            Node(FlowCapture capture) {
                this.capture = capture;
            }

            Node seekWithoutCrossing(long barrier) {
                Node newestOlderThanThreshold = null;
                for (Node candidate = this; candidate != null && candidate.captureNanoTime() < barrier; candidate = candidate.getNext()) {
                    newestOlderThanThreshold = candidate;
                }
                return newestOlderThanThreshold;
            }

            long captureNanoTime() {
                return this.capture.nanoTime();
            }

            void setNext(Node nextNode) {
                this.next = nextNode;
            }

            Node getNext() {
                return this.next;
            }

            Node getNextPlain() {
                return NEXT.get(this);
            }

            static {
                try {
                    MethodHandles.Lookup l = MethodHandles.lookup();
                    NEXT = l.findVarHandle(Node.class, "next", Node.class);
                }
                catch (ReflectiveOperationException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
        }
    }
}

