"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorHistogram = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _hooks = require("../../../hooks");
var _contexts = require("../../../contexts");
var _selectors = require("../../../state/selectors");
var _get_histogram_interval = require("../../../../../common/lib/get_histogram_interval");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorHistogram = ({
  items
}) => {
  var _data$aggregations$hi, _data$aggregations;
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const {
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const monitorIds = (items !== null && items !== void 0 ? items : []).map(({
    monitor_id: monitorId
  }) => monitorId);
  const {
    queryParams,
    minInterval
  } = getQueryParams(dateRangeStart, dateRangeEnd, monitorIds, (settings === null || settings === void 0 ? void 0 : settings.heartbeatIndices) || '');
  const {
    data,
    loading
  } = (0, _public.useEsSearch)(queryParams, [JSON.stringify(monitorIds), lastRefresh], {
    name: 'getMonitorDownHistory'
  });
  const histogramBuckets = (_data$aggregations$hi = data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : _data$aggregations.histogram.buckets) !== null && _data$aggregations$hi !== void 0 ? _data$aggregations$hi : [];
  // @ts-ignore 4.3.5 upgrade
  const simplified = histogramBuckets.map(histogramBucket => {
    const byId = {};
    histogramBucket.by_id.buckets.forEach(idBucket => {
      byId[idBucket.key] = idBucket.totalDown.value;
    });
    return {
      byId,
      timestamp: histogramBucket.key
    };
  });
  const histogramsById = {};
  monitorIds.forEach(id => {
    const points = [];
    simplified.forEach(({
      byId,
      timestamp
    }) => {
      points.push({
        timestamp,
        up: undefined,
        down: byId[id]
      });
    });
    histogramsById[id] = {
      points
    };
  });
  return {
    histogramsById,
    loading,
    minInterval
  };
};
exports.useMonitorHistogram = useMonitorHistogram;
const getQueryParams = (dateRangeStart, dateRangeEnd, monitorIds, index) => {
  const minInterval = (0, _get_histogram_interval.getHistogramInterval)(dateRangeStart, dateRangeEnd, 12);
  const queryParams = {
    index,
    body: {
      size: 0,
      query: {
        bool: {
          filter: [{
            range: {
              'summary.down': {
                gt: 0
              }
            }
          }, {
            terms: {
              'monitor.id': monitorIds
            }
          }, {
            range: {
              '@timestamp': {
                gte: dateRangeStart,
                lte: dateRangeEnd
              }
            }
          }]
        }
      },
      aggs: {
        histogram: {
          date_histogram: {
            field: '@timestamp',
            // 12 seems to be a good size for performance given
            // long monitor lists of up to 100 on the overview page
            fixed_interval: minInterval + 'ms'
          },
          aggs: {
            by_id: {
              terms: {
                field: 'monitor.id',
                size: Math.max(monitorIds.length, 1)
              },
              aggs: {
                totalDown: {
                  sum: {
                    field: 'summary.down'
                  }
                }
              }
            }
          }
        }
      }
    }
  };
  return {
    queryParams,
    minInterval
  };
};