"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationCompletedModalStep = exports.MigrationCompletedFlyoutStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MigrationCompleteStep = ({
  meta,
  resolutionType,
  dataStreamName
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "dataStreamMigrationCompletedDescription"
  }, resolutionType === 'delete' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.completeStep.changesDescription",
    defaultMessage: "Success! Data stream {dataStreamName} successfully deleted.",
    values: {
      dataStreamName: dataStreamName && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, dataStreamName)
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.completeStep.changesDescription",
    defaultMessage: "Success! {count, plural, =0 {backing indices} =1 {# backing index} other {# backing indices}} from {dataStreamName} successfully {resolutionType, select, reindex {reindexed} readonly {set to read-only} other {migrated}}.",
    values: {
      count: (meta === null || meta === void 0 ? void 0 : meta.indicesRequiringUpgradeCount) || 0,
      resolutionType,
      dataStreamName: dataStreamName && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, dataStreamName)
    }
  })));
};
const MigrationCompletedFlyoutStep = ({
  meta,
  resolutionType,
  close,
  dataStreamName
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "data-test-subj": "dataStreamMigrationCompletedTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.acceptChangesTitle",
    defaultMessage: "Data Stream Migration Complete"
  }))), /*#__PURE__*/_react.default.createElement(MigrationCompleteStep, {
    meta: meta,
    resolutionType: resolutionType,
    dataStreamName: dataStreamName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: close,
    flush: "left",
    "data-test-subj": "closeDataStreamReindexingButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.completedStep.closeButtonLabel",
    defaultMessage: "Close"
  }))))));
};
exports.MigrationCompletedFlyoutStep = MigrationCompletedFlyoutStep;
const MigrationCompletedModalStep = ({
  meta,
  resolutionType,
  close,
  dataStreamName
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "dataStreamModalTitle",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.modal.completedStep.title",
    defaultMessage: "{resolutionType, select, delete {Deleting data stream completed} other {Setting data stream to read-only completed}}",
    values: {
      resolutionType
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(MigrationCompleteStep, {
    meta: meta,
    resolutionType: resolutionType,
    dataStreamName: dataStreamName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: close,
    flush: "left",
    "data-test-subj": "closeDataStreamReindexingButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.modal.completedStep.closeButtonLabel",
    defaultMessage: "Close"
  }))))));
};
exports.MigrationCompletedModalStep = MigrationCompletedModalStep;