"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttributesAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _attributes_table = require("./attributes_table");
var _attributes_empty_prompt = require("./attributes_empty_prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const AttributesAccordion = ({
  id,
  title,
  tooltipMessage,
  fields,
  hit,
  dataView,
  columns,
  columnsMeta,
  searchTerm,
  onAddColumn,
  onRemoveColumn,
  filter,
  isEsqlMode = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  // TODO: Re-add EuiAccordion once the buggy interaction between it and EuiDataGrid is
  // resolved. https://github.com/elastic/kibana/issues/242652
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    id: id,
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", {
    css: {
      marginRight: euiTheme.size.xs
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": tooltipMessage,
    type: "questionInCircle",
    color: "subdued",
    size: "s",
    content: tooltipMessage,
    iconProps: {
      className: 'eui-alignTop'
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    size: "m",
    color: "subdued"
  }, fields.length)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    paddingSize: "m"
  }, fields.length === 0 ? /*#__PURE__*/_react.default.createElement(_attributes_empty_prompt.AttributesEmptyPrompt, null) : /*#__PURE__*/_react.default.createElement(_attributes_table.AttributesTable, {
    hit: hit,
    dataView: dataView,
    columns: columns,
    columnsMeta: columnsMeta,
    fields: fields,
    searchTerm: searchTerm,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    filter: filter,
    isEsqlMode: isEsqlMode
  })));
};
exports.AttributesAccordion = AttributesAccordion;