"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTermsAggConfig = getTermsAggConfig;
var _terms_form_component = require("./terms_form_component");
var _pivot_aggs = require("../../../../../../common/pivot_aggs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTermsAggConfig(commonConfig) {
  const field = (0, _pivot_aggs.isPivotAggsConfigWithUiBase)(commonConfig) ? commonConfig.field : null;
  return {
    ...commonConfig,
    isSubAggsSupported: false,
    isMultiField: false,
    AggFormComponent: _terms_form_component.TermsAggForm,
    field,
    aggConfig: {
      size: _pivot_aggs.TERMS_AGG_DEFAULT_SIZE
    },
    setUiConfigFromEs(esAggDefinition) {
      const {
        field: esField,
        size
      } = esAggDefinition;
      this.field = esField;
      this.aggConfig.size = size;
    },
    getEsAggConfig() {
      if (!this.isValid()) {
        return null;
      }
      return {
        field: this.field,
        size: this.aggConfig.size
      };
    },
    isValid() {
      return typeof this.aggConfig.size === 'number' && this.aggConfig.size > 0;
    }
  };
}