"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.integerRangeMinus1To100Validator = void 0;
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const numberRangeMinus1To100NotValidErrorMessage = _i18n.i18n.translate('xpack.transform.transformSettingValidations.numberGreaterThanOrEqualToNegativeOneNotValidErrorMessage', {
  defaultMessage: 'Number of retries needs to be between 0 and 100, or -1 for infinite retries.'
});

// memoize validator
const validator = (0, _mlAggUtils.numberValidator)({
  min: -1,
  max: 100,
  integerOnly: true
});
const integerRangeMinus1To100Validator = value => validator(+value) === null ? [] : [numberRangeMinus1To100NotValidErrorMessage];
exports.integerRangeMinus1To100Validator = integerRangeMinus1To100Validator;