"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorValueActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_flyout_context = require("../../hooks/use_flyout_context");
var _filter_in = require("../../../query_bar/components/filter_in");
var _filter_out = require("../../../query_bar/components/filter_out");
var _add_to_timeline = require("../../../timeline/components/add_to_timeline");
var _field_value = require("../../utils/field_value");
var _copy_to_clipboard = require("../common/copy_to_clipboard");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component render a set of actions for the user.
 * Currently used in the indicators flyout (overview and table tabs).
 *
 * It gets a readOnly boolean from context, that drives what is displayed.
 * - in the cases view usage, we only display add to timeline and copy to clipboard.
 * - in the indicators table usave, we display all options
 */
const IndicatorValueActions = ({
  indicator,
  field,
  'data-test-subj': dataTestSubj
}) => {
  const {
    kqlBarIntegration
  } = (0, _use_flyout_context.useIndicatorsFlyoutContext)();
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const {
    key,
    value
  } = (0, _field_value.getIndicatorFieldAndValue)(indicator, field);
  if (!(0, _field_value.fieldAndValueValid)(key, value)) {
    return null;
  }
  const filterInTestId = `${dataTestSubj}${_test_ids.FILTER_IN_BUTTON_TEST_ID}`;
  const filterOutTestId = `${dataTestSubj}${_test_ids.FILTER_OUT_BUTTON_TEST_ID}`;
  const timelineTestId = `${dataTestSubj}${_test_ids.TIMELINE_BUTTON_TEST_ID}`;
  const copyToClipboardTestId = `${dataTestSubj}${_test_ids.COPY_TO_CLIPBOARD_BUTTON_TEST_ID}`;
  const popoverTestId = `${dataTestSubj}${_test_ids.POPOVER_BUTTON_TEST_ID}`;
  if (kqlBarIntegration) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_add_to_timeline.AddToTimelineButtonIcon, {
      data: indicator,
      field: field,
      "data-test-subj": timelineTestId
    }), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard.CopyToClipboardButtonIcon, {
      value: value,
      "data-test-subj": copyToClipboardTestId
    }));
  }
  const popoverItems = [/*#__PURE__*/_react.default.createElement(_add_to_timeline.AddToTimelineContextMenu, {
    data: indicator,
    field: field,
    "data-test-subj": timelineTestId
  }), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard.CopyToClipboardContextMenu, {
    value: value,
    "data-test-subj": copyToClipboardTestId
  })];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_filter_in.FilterInButtonIcon, {
    data: indicator,
    field: field,
    "data-test-subj": filterInTestId
  }), /*#__PURE__*/_react.default.createElement(_filter_out.FilterOutButtonIcon, {
    data: indicator,
    field: field,
    "data-test-subj": filterOutTestId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": popoverTestId,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _translations.MORE_ACTIONS_BUTTON_LABEL
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _translations.MORE_ACTIONS_BUTTON_LABEL,
      iconType: "boxesHorizontal",
      iconSize: "s",
      size: "xs",
      onClick: () => setPopover(prevIsPopoverOpen => !prevIsPopoverOpen),
      style: {
        height: '100%'
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setPopover(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: popoverItems
  })));
};
exports.IndicatorValueActions = IndicatorValueActions;