"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeHttpFetchError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serializeHttpFetchError = (error, getPayload) => {
  if (error.name && !error.body) {
    var _error$request;
    return {
      name: error.name,
      body: {
        error: error.toString(),
        message: error.message,
        statusCode: undefined
      },
      requestUrl: error === null || error === void 0 ? void 0 : (_error$request = error.request) === null || _error$request === void 0 ? void 0 : _error$request.url,
      getPayload
    };
  }
  const body = error.body;
  return {
    name: error.name,
    body: {
      error: body.error,
      message: body.message,
      statusCode: body.statusCode
    },
    requestUrl: error.request.url,
    getPayload
  };
};
exports.serializeHttpFetchError = serializeHttpFetchError;