"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRENDS_CHUNK_SIZE = void 0;
exports.fetchOverviewTrendStats = fetchOverviewTrendStats;
exports.fetchTrendEffect = fetchTrendEffect;
exports.refreshOverviewTrendStats = refreshOverviewTrendStats;
exports.refreshTrends = refreshTrends;
var _effects = require("redux-saga/effects");
var _overview_status = require("../overview_status");
var _selectors = require("./selectors");
var _actions = require("./actions");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRENDS_CHUNK_SIZE = exports.TRENDS_CHUNK_SIZE = 250;
function* fetchTrendEffect(action) {
  try {
    // batch requests LIFO as the user scrolls
    for (let i = action.payload.length; i > 0; i -= TRENDS_CHUNK_SIZE) {
      const chunk = action.payload.slice(Math.max(i - TRENDS_CHUNK_SIZE, 0), i);
      if (chunk.length > 0) {
        const trendStats = yield (0, _effects.call)(_api.fetchOverviewTrendStats, chunk);
        yield (0, _effects.put)(_actions.trendStatsBatch.success({
          trendStats,
          batch: chunk
        }));
      }
    }
  } catch (e) {
    yield (0, _effects.put)(_actions.trendStatsBatch.fail(action.payload));
  }
}
function* fetchOverviewTrendStats() {
  yield (0, _effects.takeEvery)(_actions.trendStatsBatch.get, fetchTrendEffect);
}
function* refreshTrends() {
  const existingTrends = yield (0, _effects.select)(_selectors.selectOverviewTrends);
  const {
    allConfigs
  } = yield (0, _effects.select)(_overview_status.selectOverviewStatus);
  const monitorConfigs = Object.values(allConfigs !== null && allConfigs !== void 0 ? allConfigs : {});
  const keys = Object.keys(existingTrends);
  while (keys.length) {
    const chunk = keys.splice(0, keys.length < 10 ? keys.length : 40).filter(key => existingTrends[key] !== null && existingTrends[key] !== 'loading' && monitorConfigs.some(({
      configId
    }) => configId === existingTrends[key].configId)).map(key => {
      const trend = existingTrends[key];
      return {
        configId: trend.configId,
        locationId: trend.locationId,
        schedule: monitorConfigs.find(({
          configId
        }) => configId === trend.configId).schedule
      };
    });
    if (chunk.length) {
      const trendStats = yield (0, _effects.call)(_api.fetchOverviewTrendStats, chunk);
      yield (0, _effects.put)(_actions.trendStatsBatch.success({
        trendStats,
        batch: chunk
      }));
    }
  }
}
function* refreshOverviewTrendStats() {
  yield (0, _effects.takeLeading)(_actions.refreshOverviewTrends.get, refreshTrends);
}