"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorName = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _public = require("@kbn/observability-shared-plugin/public");
var _state = require("../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorName = ({
  search = ''
}) => {
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const [debouncedSearch, setDebouncedSearch] = (0, _react.useState)(search);
  (0, _useDebounce.default)(() => setDebouncedSearch(search), 500, [search]);
  const {
    loading,
    data: monitors
  } = (0, _public.useFetcher)(async () => {
    var _fetchedResult$monito;
    const fetchedResult = await (0, _state.fetchMonitorManagementList)((0, _state.getMonitorListPageStateWithDefaults)({
      query: debouncedSearch
    }));
    return ((_fetchedResult$monito = fetchedResult === null || fetchedResult === void 0 ? void 0 : fetchedResult.monitors) !== null && _fetchedResult$monito !== void 0 ? _fetchedResult$monito : []).map(monitor => ({
      label: monitor.name,
      key: monitor.config_id,
      locationIds: monitor.locations.map(location => location.id)
    }));
  }, [debouncedSearch]);
  return (0, _react.useMemo)(() => {
    const searchPattern = search.replace(/\s/g, '').toLowerCase();
    const nameAlreadyExists = Boolean((monitors !== null && monitors !== void 0 ? monitors : []).some(monitor => monitorId !== monitor.key && monitor.label.replace(/\s/g, '').toLowerCase() === searchPattern));
    return {
      loading: loading || debouncedSearch !== search,
      // Also keep busy while waiting for debounce
      nameAlreadyExists,
      values: (monitors !== null && monitors !== void 0 ? monitors : []).filter(val => val.key !== monitorId)
    };
  }, [loading, monitorId, monitors, search, debouncedSearch]);
};
exports.useMonitorName = useMonitorName;