"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilteredGroupMonitors = void 0;
var _reactRedux = require("react-redux");
var _state = require("../../../../../state");
var _overview_status = require("../../../../../state/overview_status");
var _hooks = require("../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFilteredGroupMonitors = ({
  groupMonitors
}) => {
  const {
    status: overviewStatus
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const {
    statusFilter
  } = (0, _hooks.useGetUrlParams)();
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  if (statusFilter === 'all' || !statusFilter) return groupMonitors;
  if (statusFilter === 'disabled') return groupMonitors.filter(monitor => !monitor.isEnabled);
  return groupMonitors.filter(monitor => {
    var _locations$find$label, _locations$find;
    const locationLabel = (_locations$find$label = (_locations$find = locations.find(location => location.id === monitor.locationId)) === null || _locations$find === void 0 ? void 0 : _locations$find.label) !== null && _locations$find$label !== void 0 ? _locations$find$label : monitor.locationId;
    const status = (0, _hooks.getConfigStatusByLocation)(overviewStatus, monitor.configId, locationLabel);
    if (statusFilter === 'up' && status.status === 'up') {
      return true;
    } else if (statusFilter === 'down' && status.status === 'down') {
      return true;
    }
    return false;
  });
};
exports.useFilteredGroupMonitors = useFilteredGroupMonitors;