"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOverviewTrendsRequests = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOverviewTrendsRequests = (monitorsSortedByStatus, maxItem) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const trendData = (0, _reactRedux.useSelector)(_state.selectOverviewTrends);
  (0, _react.useEffect)(() => {
    const trendRequests = monitorsSortedByStatus.reduce((acc, item) => {
      if (trendData[item.configId + item.locationId] === undefined) {
        acc.push({
          configId: item.configId,
          locationId: item.locationId,
          schedule: item.schedule
        });
      }
      return acc;
    }, []);
    if (trendRequests.length) dispatch(_state.trendStatsBatch.get(trendRequests));
  }, [dispatch, maxItem, monitorsSortedByStatus, trendData]);
};
exports.useOverviewTrendsRequests = useOverviewTrendsRequests;