"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottlingDownloadField = exports.DOWNLOAD_SPEED_ERROR = exports.DOWNLOAD_LABEL = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _throttling_exceeded_callout = require("./throttling_exceeded_callout");
var _optional_label = require("../optional_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThrottlingDownloadField = ({
  handleInputChange,
  readOnly,
  onFieldBlur,
  validate,
  throttling,
  throttlingValue
}) => {
  var _validate$ConfigKey$T;
  const maxDownload = Number(_runtime_types.DEFAULT_BANDWIDTH_LIMIT[_runtime_types.BandwidthLimitKey.DOWNLOAD]);
  const exceedsDownloadLimits = Number(throttlingValue.download) > maxDownload;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: DOWNLOAD_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_label.OptionalLabel, null),
    isInvalid: (validate ? !!(validate !== null && validate !== void 0 && (_validate$ConfigKey$T = validate[_runtime_types.ConfigKey.THROTTLING_CONFIG]) !== null && _validate$ConfigKey$T !== void 0 && _validate$ConfigKey$T.call(validate, throttling)) : false) || exceedsDownloadLimits,
    error: exceedsDownloadLimits ? /*#__PURE__*/_react.default.createElement(_throttling_exceeded_callout.ThrottlingExceededMessage, {
      throttlingField: "download",
      limit: maxDownload
    }) : DOWNLOAD_SPEED_ERROR
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 0,
    step: 0.001,
    value: throttlingValue.download,
    onChange: event => {
      handleInputChange(event.target.value);
    },
    onBlur: () => onFieldBlur === null || onFieldBlur === void 0 ? void 0 : onFieldBlur('download'),
    "data-test-subj": "syntheticsBrowserDownloadSpeed",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, "Mbps")),
    readOnly: readOnly
  }));
};
exports.ThrottlingDownloadField = ThrottlingDownloadField;
const DOWNLOAD_LABEL = exports.DOWNLOAD_LABEL = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.browserAdvancedSettings.throttling.download.label', {
  defaultMessage: 'Download Speed'
});
const DOWNLOAD_SPEED_ERROR = exports.DOWNLOAD_SPEED_ERROR = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.browserAdvancedSettings.throttling.download.error', {
  defaultMessage: 'Download speed must be greater than zero.'
});