"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSLOSuggestionsRoute = void 0;
var _get_slo_suggestions = require("../../services/get_slo_suggestions");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSLOSuggestionsRoute = exports.getSLOSuggestionsRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /internal/observability/slos/suggestions',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_read']
    }
  },
  handler: async ({
    request,
    logger,
    plugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      soClient
    } = await getScopedClients({
      request,
      logger
    });
    const getSLOSuggestions = new _get_slo_suggestions.GetSLOSuggestions(soClient);
    return await getSLOSuggestions.execute();
  }
});