"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAllFilters = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatAllFilters = (globalFilters = '', groupByCardinalityFilters) => {
  if (_sloSchema.kqlQuerySchema.is(globalFilters)) {
    return {
      kqlQuery: globalFilters,
      filters: groupByCardinalityFilters
    };
  } else if (_sloSchema.kqlWithFiltersSchema.is(globalFilters)) {
    return {
      kqlQuery: globalFilters.kqlQuery,
      filters: [...globalFilters.filters, ...groupByCardinalityFilters]
    };
  } else {
    return {
      kqlQuery: '',
      filters: groupByCardinalityFilters
    };
  }
};
exports.formatAllFilters = formatAllFilters;