"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      colors,
      size
    } = euiTheme;
    const container = {
      position: 'relative'
    };
    const stickyItem = {
      position: 'sticky',
      top: 0,
      zIndex: 1,
      backgroundColor: colors.emptyShade
    };
    const viewMode = {
      margin: size.base
    };
    const loadMoreBtn = {
      margin: size.m,
      width: `calc(100% - ${size.m} * 2)`
    };
    return {
      container,
      stickyItem,
      viewMode,
      loadMoreBtn
    };
  }, [euiTheme]);
  return cached;
};
exports.useStyles = useStyles;