"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineManageButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../hooks/use_kibana");
var _use_ingest_pipelines = require("../hooks/api/use_ingest_pipelines");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineManageButton = () => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const {
    data
  } = (0, _use_ingest_pipelines.useIngestPipelines)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: !(data !== null && data !== void 0 && data.canManagePipelines),
    size: "m",
    href: http.basePath.prepend('/app/management/ingest/ingest_pipelines'),
    "data-test-subj": "manage-pipeline-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.serverlessSearch.pipeline.description.manageButtonLabel', {
    defaultMessage: 'Manage pipelines'
  }))));
};
exports.PipelineManageButton = PipelineManageButton;