"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNavigationTree = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createNavigationTree = ({
  streamsAvailable
}) => {
  return {
    body: [{
      type: 'recentlyAccessed'
    }, {
      type: 'navGroup',
      id: 'observability_project_nav',
      title: 'Observability',
      icon: 'logoObservability',
      defaultIsCollapsed: false,
      isCollapsible: false,
      breadcrumbStatus: 'hidden',
      children: [{
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.discover', {
          defaultMessage: 'Discover'
        }),
        link: 'last-used-logs-viewer',
        // avoid duplicate "Discover" breadcrumbs
        breadcrumbStatus: 'hidden',
        renderAs: 'item',
        children: [{
          link: 'discover',
          children: [{
            link: 'observability-logs-explorer'
          }]
        }]
      }, {
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.dashboards', {
          defaultMessage: 'Dashboards'
        }),
        link: 'dashboards',
        getIsActive: ({
          pathNameSerialized,
          prepend
        }) => {
          return pathNameSerialized.startsWith(prepend('/app/dashboards'));
        }
      }, {
        link: 'observability-overview:alerts'
      }, {
        link: 'observability-overview:cases',
        renderAs: 'item',
        children: [{
          link: 'observability-overview:cases_configure'
        }, {
          link: 'observability-overview:cases_create'
        }]
      }, {
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.slo', {
          defaultMessage: 'SLOs'
        }),
        link: 'slo'
      }, {
        link: 'observabilityAIAssistant',
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.aiAssistant', {
          defaultMessage: 'AI Assistant'
        })
      }, ...(streamsAvailable ? [{
        link: 'streams',
        withBadge: true,
        badgeOptions: {
          icon: 'beaker',
          tooltip: _i18n.i18n.translate('xpack.serverlessObservability.nav.streamsBadgeTooltip', {
            defaultMessage: 'This functionality is experimental and not supported. It may change or be removed at any time.'
          })
        }
      }] : []), {
        id: 'applications',
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.applications', {
          defaultMessage: 'Applications'
        }),
        renderAs: 'panelOpener',
        children: [{
          id: 'apm',
          children: [{
            link: 'apm:services',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.apm.services', {
              defaultMessage: 'Service inventory'
            })
          }, {
            link: 'apm:traces'
          }, {
            link: 'apm:dependencies'
          }, {
            link: 'apm:settings',
            sideNavStatus: 'hidden'
          }, {
            id: 'synthetics',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.synthetics', {
              defaultMessage: 'Synthetics'
            }),
            children: [{
              title: _i18n.i18n.translate('xpack.serverlessObservability.nav.synthetics.overviewItem', {
                defaultMessage: 'Overview'
              }),
              id: 'synthetics-overview',
              link: 'synthetics:overview',
              breadcrumbStatus: 'hidden'
            }, {
              link: 'synthetics:certificates',
              title: _i18n.i18n.translate('xpack.serverlessObservability.nav.synthetics.certificatesItem', {
                defaultMessage: 'TLS certificates'
              }),
              id: 'synthetics-certificates',
              breadcrumbStatus: 'hidden'
            }]
          }]
        }]
      }, {
        id: 'metrics',
        link: 'metrics:inventory',
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.infrastructure', {
          defaultMessage: 'Infrastructure'
        }),
        renderAs: 'panelOpener',
        children: [{
          children: [{
            link: 'metrics:inventory',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.infrastructureInventory', {
              defaultMessage: 'Infrastructure inventory'
            })
          }, {
            link: 'metrics:hosts'
          }, {
            link: 'metrics:settings',
            sideNavStatus: 'hidden'
          }]
        }]
      }, {
        id: 'machine_learning-landing',
        renderAs: 'panelOpener',
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.machineLearning', {
          defaultMessage: 'Machine learning'
        }),
        children: [{
          children: [{
            link: 'ml:overview'
          }, {
            link: 'ml:notifications'
          }, {
            link: 'ml:memoryUsage',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.machineLearning.memoryUsage', {
              defaultMessage: 'Memory usage'
            })
          }]
        }, {
          id: 'category-anomaly_detection',
          title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.anomaly_detection', {
            defaultMessage: 'Anomaly detection'
          }),
          breadcrumbStatus: 'hidden',
          children: [{
            link: 'ml:anomalyDetection',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.anomaly_detection.jobs', {
              defaultMessage: 'Jobs'
            })
          }, {
            link: 'ml:anomalyExplorer'
          }, {
            link: 'ml:singleMetricViewer'
          }, {
            link: 'ml:settings'
          }, {
            link: 'ml:suppliedConfigurations'
          }]
        }, {
          id: 'category-data_frame analytics',
          title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.data_frame_analytics', {
            defaultMessage: 'Data frame analytics'
          }),
          breadcrumbStatus: 'hidden',
          children: [{
            link: 'ml:dataFrameAnalytics',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.data_frame_analytics.jobs', {
              defaultMessage: 'Jobs'
            })
          }, {
            link: 'ml:resultExplorer'
          }, {
            link: 'ml:analyticsMap'
          }]
        }, {
          id: 'category-model_management',
          title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.model_management', {
            defaultMessage: 'Model management'
          }),
          breadcrumbStatus: 'hidden',
          children: [{
            link: 'ml:nodesOverview',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.model_management.trainedModels', {
              defaultMessage: 'Trained models'
            })
          }]
        }, {
          id: 'category-data_visualizer',
          title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.data_visualizer', {
            defaultMessage: 'Data visualizer'
          }),
          breadcrumbStatus: 'hidden',
          children: [{
            link: 'ml:fileUpload',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.data_visualizer.file_data_visualizer', {
              defaultMessage: 'File data visualizer'
            })
          }, {
            link: 'ml:indexDataVisualizer',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.data_visualizer.data_view_data_visualizer', {
              defaultMessage: 'Data view data visualizer'
            })
          }, {
            link: 'ml:dataDrift',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.data_visualizer.data_drift', {
              defaultMessage: 'Data drift'
            })
          }]
        }, {
          id: 'category-aiops_labs',
          title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.aiops_labs', {
            defaultMessage: 'Aiops labs'
          }),
          breadcrumbStatus: 'hidden',
          children: [{
            link: 'ml:logRateAnalysis',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.aiops_labs.log_rate_analysis', {
              defaultMessage: 'Log rate analysis'
            })
          }, {
            link: 'ml:logPatternAnalysis',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.aiops_labs.log_pattern_analysis', {
              defaultMessage: 'Log pattern analysis'
            })
          }, {
            link: 'ml:changePointDetections',
            title: _i18n.i18n.translate('xpack.serverlessObservability.nav.ml.aiops_labs.change_point_detection', {
              defaultMessage: 'Change point detection'
            })
          }]
        }]
      }]
    }],
    footer: [{
      type: 'navItem',
      title: _i18n.i18n.translate('xpack.serverlessObservability.nav.getStarted', {
        defaultMessage: 'Add data'
      }),
      link: 'observabilityOnboarding',
      icon: 'launch'
    }, {
      type: 'navItem',
      id: 'devTools',
      title: _i18n.i18n.translate('xpack.serverlessObservability.nav.devTools', {
        defaultMessage: 'Developer tools'
      }),
      link: 'dev_tools',
      icon: 'editorCodeBlock'
    }, {
      type: 'navGroup',
      id: 'project_settings_project_nav',
      title: _i18n.i18n.translate('xpack.serverlessObservability.nav.projectSettings', {
        defaultMessage: 'Project settings'
      }),
      icon: 'gear',
      breadcrumbStatus: 'hidden',
      children: [{
        id: 'management',
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.mngt', {
          defaultMessage: 'Management'
        }),
        spaceBefore: null,
        renderAs: 'panelOpener',
        children: [{
          title: _i18n.i18n.translate('xpack.serverlessObservability.nav.mngt.data', {
            defaultMessage: 'Data'
          }),
          breadcrumbStatus: 'hidden',
          children: [{
            link: 'management:index_management',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:transform',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:ingest_pipelines',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:dataViews',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:jobsListLink',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:pipelines',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:data_quality',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:data_usage',
            breadcrumbStatus: 'hidden'
          }]
        }, {
          title: _i18n.i18n.translate('xpack.serverlessObservability.nav.mngt.access', {
            defaultMessage: 'Access'
          }),
          breadcrumbStatus: 'hidden',
          children: [{
            link: 'management:api_keys',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:roles',
            breadcrumbStatus: 'hidden'
          }, {
            cloudLink: 'userAndRoles',
            title: _i18n.i18n.translate('xpack.serverlessObservability.navLinks.projectSettings.mngt.usersAndRoles', {
              defaultMessage: 'Manage organization members'
            })
          }]
        }, {
          title: _i18n.i18n.translate('xpack.serverlessObservability.nav.mngt.alertsAndInsights', {
            defaultMessage: 'Alerts and insights'
          }),
          breadcrumbStatus: 'hidden',
          children: [{
            link: 'management:triggersActionsConnectors',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:maintenanceWindows',
            breadcrumbStatus: 'hidden'
          }]
        }, {
          title: _i18n.i18n.translate('xpack.serverlessObservability.nav.mngt.content', {
            defaultMessage: 'Content'
          }),
          breadcrumbStatus: 'hidden',
          children: [{
            link: 'management:spaces',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:objects',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:filesManagement',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:reporting',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:tags',
            breadcrumbStatus: 'hidden'
          }]
        }, {
          title: _i18n.i18n.translate('xpack.serverlessObservability.nav.mngt.other', {
            defaultMessage: 'Other'
          }),
          breadcrumbStatus: 'hidden',
          children: [{
            link: 'management:settings',
            breadcrumbStatus: 'hidden'
          }, {
            link: 'management:observabilityAiAssistantManagement',
            breadcrumbStatus: 'hidden'
          }]
        }, {
          id: 'cloudLinkBilling',
          cloudLink: 'billingAndSub'
        }]
      }, {
        link: 'integrations'
      }, {
        link: 'fleet'
      }, {
        id: 'cloudLinkUserAndRoles',
        cloudLink: 'userAndRoles'
      }, {
        id: 'cloudLinkBilling',
        cloudLink: 'billingAndSub'
      }]
    }]
  };
};
exports.createNavigationTree = createNavigationTree;