"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityDashboardRegistration = createObservabilityDashboardRegistration;
var rt = _interopRequireWildcard(require("io-ts"));
var _rxjs = require("rxjs");
var _ioTsUtils = require("@kbn/io-ts-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// check log data streams that match the naming convention, except for the APM
// error stream, because its presence would always mask the "APM only" case
const LOG_DATA_INDICES = 'logs-*-*,-logs-apm.error-*';
function createObservabilityDashboardRegistration({
  search
}) {
  return {
    appName: 'infra_logs',
    fetchData: fetchObservabilityDashboardData,
    hasData: hasObservabilityDashboardData({
      search
    })
  };
}
async function fetchObservabilityDashboardData() {
  throw new Error('Overview data fetching has not been implemented for serverless deployments.');
}
const hasObservabilityDashboardData = ({
  search
}) => async () => {
  const hasData = await (0, _rxjs.lastValueFrom)((await search)({
    params: {
      ignore_unavailable: true,
      allow_no_indices: true,
      index: LOG_DATA_INDICES,
      size: 0,
      terminate_after: 1,
      track_total_hits: 1
    }
  })).then(({
    rawResponse
  }) => {
    if (rawResponse._shards.total <= 0) {
      return false;
    }
    const totalHits = decodeTotalHits(rawResponse.hits.total);
    if (typeof totalHits === 'number' ? totalHits > 0 : totalHits.value > 0) {
      return true;
    }
    return false;
  }, err => {
    if (err.status === 404) {
      return false;
    }
    throw new Error(`Failed to check status of log indices "${LOG_DATA_INDICES}": ${err}`);
  });
  return {
    hasData,
    indices: LOG_DATA_INDICES
  };
};
const decodeTotalHits = (0, _ioTsUtils.decodeOrThrow)(rt.union([rt.number, rt.type({
  value: rt.number
})]));