"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.concurrentlyExec = void 0;
var _pLimit = _interopRequireDefault(require("p-limit"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This type is just an async function's type
 */

/**
 * Helper function to call a large number of async functions with limited concurrency.
 * Example pattern of how to create functions to pass in:
 *
 * const ruleCopies = duplicateRuleParams(basicRule, 200);
 * const functions = ruleCopies.map((rule) => () => detectionsClient.createRule({ body: rule }));
 *
 * Note that the `map` call in the example returns a *function* that calls detectionsClient.createRule, it doesn't call createRule immediately.
 *
 * @param functions Async functions to call with limited concurrency
 * @param concurrency Maximum number of concurrent function calls
 * @returns Results from all functions passed in
 */
const concurrentlyExec = async (requestFactories, concurrency = 10) => {
  const limiter = (0, _pLimit.default)(concurrency);
  const promises = requestFactories.map(f => limiter(f));
  return Promise.all(promises);
};
exports.concurrentlyExec = concurrentlyExec;