"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionServerlessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _dashboards_landing_callout = require("./components/dashboards_landing_callout");
var _upselling = require("./upselling");
var _create_services = require("./common/services/create_services");
var _navigation = require("./navigation");
var _experimental_features = require("../common/experimental_features");
var _onboarding = require("./onboarding");
var _additional_charges_message = require("./components/additional_charges_message");
var _pli_features = require("../common/pli/pli_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecuritySolutionServerlessPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = {};
  }
  setup(core, setupDeps) {
    const {
      securitySolution
    } = setupDeps;
    const {
      productTypes,
      enableExperimental,
      inaccessibleApps
    } = this.config;
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(enableExperimental, securitySolution.experimentalFeatures).features;
    securitySolution.setProductFeatureKeys((0, _pli_features.getEnabledProductFeatures)(productTypes));
    setupDeps.discover.showInlineTopNav();
    updateInaccessibleApps(inaccessibleApps, core);
    return {};
  }
  start(core, startDeps) {
    const {
      securitySolution
    } = startDeps;
    const {
      productTypes
    } = this.config;
    const services = (0, _create_services.createServices)(core, startDeps, this.experimentalFeatures);
    (0, _upselling.registerUpsellings)(productTypes, services);
    securitySolution.setComponents({
      DashboardsLandingCallout: (0, _dashboards_landing_callout.getDashboardsLandingCallout)(services),
      AdditionalChargesMessage: (0, _additional_charges_message.getAdditionalChargesMessage)(services)
    });
    (0, _onboarding.setOnboardingSettings)(services);
    (0, _navigation.startNavigation)(services, productTypes);
    return {};
  }
  stop() {}
}

/**
 * Disables apps that are inaccessible based on the provided configuration.
 * It updates the app status to 'inaccessible' for those apps.
 * The apps will still execute their lifecycle methods, but it will remain inaccessible in the UI.
 */
exports.SecuritySolutionServerlessPlugin = SecuritySolutionServerlessPlugin;
const updateInaccessibleApps = (inaccessibleApps, core) => {
  if (!(inaccessibleApps !== null && inaccessibleApps !== void 0 && inaccessibleApps.length)) {
    return;
  }
  const inaccessibleAppsSet = new Set(inaccessibleApps);
  const appUpdater$ = new _rxjs.BehaviorSubject(app => {
    if (inaccessibleAppsSet.has(app.id)) {
      return {
        status: _coreApplicationBrowser.AppStatus.inaccessible
      };
    }
  });
  core.application.registerAppUpdater(appUpdater$);
};